/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceStore {
    private final Map<Locale, LocalizationService> localizationServices = new HashMap<Locale, LocalizationService>();

    public <A> A adapt(Class<A> adapterType) {
        LocalizationService result = null;
        if (adapterType == LocalizationService.class) {
            result = this.getLocalizationService();
        }
        return (A)result;
    }

    public void save() throws ResourceStoreException {
    }

    public void validateEdit() throws ValidateEditException {
        this.validateSave();
    }

    public void validateSave() throws ValidateEditException {
    }

    public boolean isOutOfDate() {
        return false;
    }

    public final LocalizationService getLocalizationService() {
        return this.getLocalizationService(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final LocalizationService getLocalizationService(Locale locale) {
        Map<Locale, LocalizationService> map = this.localizationServices;
        synchronized (map) {
            LocalizationService service = this.localizationServices.get(locale);
            if (service == null && (service = this.initLocalizationService(locale)) != null) {
                this.localizationServices.put(locale, service);
            }
            return service;
        }
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return SourceLanguageLocalizationService.INSTANCE;
    }
}

