/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionContext {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public Object property(String name) {
        throw new FunctionException(NLS.bind((String)Resources.undefinedPropertyMessage, (Object)name));
    }

    public Function function(String name, List<Function> arguments) {
        Function function = SapphireModelingExtensionSystem.createFunction(name, arguments.toArray(new Function[arguments.size()]));
        if (function != null) {
            return function;
        }
        throw new FunctionException(NLS.bind((String)Resources.undefinedFunctionMessage, (Object)name));
    }

    public LocalizationService getLocalizationService() {
        return SourceLanguageLocalizationService.INSTANCE;
    }

    public final void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(String property) {
        for (Listener listener : this.listeners) {
            try {
                listener.handlePropertyChanged(property);
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
    }

    public void dispose() {
    }

    public static abstract class Listener {
        public abstract void handlePropertyChanged(String var1);
    }

    private static final class Resources
    extends NLS {
        public static String undefinedPropertyMessage;
        public static String undefinedFunctionMessage;

        static {
            Resources.initializeMessages((String)FunctionContext.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

