/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.EnablementService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnablementServiceFactory
extends ModelPropertyServiceFactory {
    private static EnablementService DEFAULT_ENABLEMENT_SERVICE = new EnablementService(){

        public boolean isEnabled() {
            return true;
        }
    };

    @Override
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        return true;
    }

    @Override
    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        ArrayList<EnablementService> services = new ArrayList<EnablementService>();
        for (Enablement annotation : property.getAnnotations(Enablement.class)) {
            EnablementService svc = null;
            if (!annotation.service().equals(EnablementService.class)) {
                try {
                    svc = annotation.service().newInstance();
                    svc.init(element, property, annotation.params());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    svc = null;
                }
            }
            if (svc == null && annotation.expr().length() > 0) {
                Function f = null;
                FunctionResult fr = null;
                try {
                    f = ExpressionLanguageParser.parse(annotation.expr());
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                    f = null;
                }
                if (f != null) {
                    f = FailSafeFunction.create(f, Boolean.class);
                    fr = f.evaluate(new ModelElementFunctionContext(element));
                }
                svc = new FunctionBasedEnablementService(fr);
                svc.init(element, property, new String[0]);
            }
            if (svc == null) continue;
            services.add(svc);
        }
        int count = services.size();
        EnablementService result = count == 0 ? DEFAULT_ENABLEMENT_SERVICE : (count == 1 ? (EnablementService)services.get(0) : new UnionEnablementService(services));
        return result;
    }

    private static final class FunctionBasedEnablementService
    extends EnablementService {
        private final FunctionResult functionResult;

        public FunctionBasedEnablementService(FunctionResult functionResult) {
            this.functionResult = functionResult;
        }

        public void init(final IModelElement element, final ModelProperty property, String[] params) {
            super.init(element, property, params);
            this.functionResult.addListener(new FunctionResult.Listener(){

                public void handleValueChanged() {
                    element.refresh(property);
                }
            });
        }

        public boolean isEnabled() {
            Boolean enabled = null;
            if (this.functionResult != null) {
                enabled = (Boolean)this.functionResult.value();
            }
            if (enabled == null) {
                enabled = false;
            }
            return enabled;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnionEnablementService
    extends EnablementService {
        private final List<EnablementService> enablers;

        public UnionEnablementService(List<EnablementService> enablers) {
            this.enablers = enablers;
        }

        @Override
        public boolean isEnabled() {
            for (EnablementService enabler : this.enablers) {
                try {
                    if (enabler.isEnabled()) continue;
                    return false;
                }
                catch (Exception e) {
                    SapphireModelingFrameworkPlugin.log(e);
                }
            }
            return true;
        }
    }
}

