/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import java.util.Collections;
import java.util.SequencedCollection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ModelPropertyValidator;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValuesValidator
extends ModelPropertyValidator<Value<?>> {
    public static boolean isNecessary(ValueProperty property) {
        PossibleValues annotation = property.getAnnotation(PossibleValues.class);
        return annotation != null && (!annotation.service().equals(PossibleValuesService.class) || annotation.invalidValueSeverity() != 0);
    }

    @Override
    public IStatus validate(Value<?> value) {
        PossibleValuesService valuesProvider;
        IModelElement modelElement = value.parent();
        String valueString = value.getText(true);
        if (valueString != null && (valuesProvider = modelElement.service(value.getProperty(), PossibleValuesService.class)) != null) {
            SequencedCollection<String> values = valuesProvider.getPossibleValues();
            for (String v : values) {
                if (v != null) continue;
                String msg = NLS.bind((String)Resources.valuesProviderReturnedNull, (Object)valuesProvider.getClass().getName());
                SapphireModelingFrameworkPlugin.logError(msg, null);
                values = Collections.emptyList();
            }
            boolean found = false;
            if (valuesProvider.isCaseSensitive()) {
                found = values.contains(valueString);
            } else {
                for (String v : values) {
                    if (!v.equalsIgnoreCase(valueString)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                int severity = valuesProvider.getInvalidValueSeverity(valueString);
                String message = valuesProvider.getInvalidValueMessage(valueString);
                return new Status(severity, "org.eclipse.sapphire.modeling", message);
            }
        }
        return Status.OK_STATUS;
    }

    private static final class Resources
    extends NLS {
        public static String valuesProviderReturnedNull;

        static {
            Resources.initializeMessages((String)PossibleValuesValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

