/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.assist;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyEditorAssistContext {
    private final SapphirePropertyEditor propertyEditor;
    private final SapphireRenderingContext context;
    private final LinkedHashMap<String, PropertyEditorAssistSection> sections;
    private final Map<String, PropertyEditorAssistSection> sectionsReadOnly;

    public PropertyEditorAssistContext(SapphirePropertyEditor propertyEditor, SapphireRenderingContext context) {
        this.propertyEditor = propertyEditor;
        this.context = context;
        this.sections = new LinkedHashMap();
        this.sectionsReadOnly = Collections.unmodifiableMap(this.sections);
    }

    public SapphirePropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public IModelElement getModelElement() {
        return this.propertyEditor.getModelElement();
    }

    public ModelProperty getProperty() {
        return this.propertyEditor.getProperty().refine(this.getModelElement());
    }

    public SapphireRenderingContext getUiContext() {
        return this.context;
    }

    public Shell getShell() {
        return this.context.getShell();
    }

    public boolean isEmpty() {
        for (PropertyEditorAssistSection section : this.sections.values()) {
            if (section.getContributions().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Map<String, PropertyEditorAssistSection> getSections() {
        return this.sectionsReadOnly;
    }

    public PropertyEditorAssistSection getSection(String id) {
        PropertyEditorAssistSection section = this.sections.get(id);
        if (section == null) {
            section = new PropertyEditorAssistSection(id);
            this.sections.put(id, section);
        }
        return section;
    }
}

