/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.ClassLoaderResourceResolver;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ReferenceService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.ui.def.IImportDirective;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageReferenceServiceFactory
extends ModelPropertyServiceFactory {
    public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        Reference annotation;
        return property instanceof ValueProperty && (annotation = (Reference)property.getAnnotation(Reference.class)) != null && annotation.target().equals(ImageDescriptor.class) && annotation.service().equals(ReferenceService.class);
    }

    public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
        ReferenceService svc = null;
        IModelElement root = (IModelElement)element.root();
        if (root instanceof ISapphireUiDef) {
            final ISapphireUiDef def = (ISapphireUiDef)root;
            svc = new ReferenceService(){

                public Object resolve(String reference) {
                    ImageDescriptor img = null;
                    for (IImportDirective directive : def.getImportDirectives()) {
                        img = directive.resolveImage(reference);
                        if (img != null) break;
                    }
                    return img;
                }
            };
        } else {
            final ClassLoaderResourceResolver classLoaderResourceResolver = (ClassLoaderResourceResolver)element.adapt(ClassLoaderResourceResolver.class);
            if (classLoaderResourceResolver != null) {
                svc = new ReferenceService(){

                    public Object resolve(String reference) {
                        URL url;
                        ImageDescriptor img = null;
                        if (reference != null && (url = classLoaderResourceResolver.resolve(reference)) != null) {
                            img = ImageDescriptor.createFromURL((URL)url);
                        }
                        return img;
                    }
                };
            }
        }
        return svc;
    }
}

