/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.SapphireMultiStatus;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.ProblemOverlayImageDescriptor;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphirePropertyEnabledCondition;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSection;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeDef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryDef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryEntry;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeFactoryRef;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeListEntry;
import org.eclipse.sapphire.ui.def.IMasterDetailsTreeNodeRef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireSectionDef;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;
import org.eclipse.sapphire.ui.editor.views.masterdetails.internal.ListPropertyNodeFactory;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsContentNode
extends SapphirePart {
    public static final String HINT_HIDE_IF_DISABLED = "hide.if.disabled";
    private static final ImageDescriptor IMG_DESC_CONTAINER = SapphireImageCache.OBJECT_CONTAINER_NODE;
    private static final ImageDescriptor IMG_DESC_CONTAINER_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_CONTAINER, 4);
    private static final ImageDescriptor IMG_DESC_CONTAINER_WITH_WARNING = new ProblemOverlayImageDescriptor(IMG_DESC_CONTAINER, 2);
    private static final ImageDescriptor IMG_DESC_LEAF = SapphireImageCache.OBJECT_LEAF_NODE;
    private static final ImageDescriptor IMG_DESC_LEAF_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_LEAF, 4);
    private static final ImageDescriptor IMG_DESC_LEAF_WITH_WARNING = new ProblemOverlayImageDescriptor(IMG_DESC_LEAF, 2);
    private MasterDetailsContentTree contentTree;
    private IMasterDetailsTreeNodeDef definition;
    private IModelElement modelElement;
    private ImpliedElementProperty modelElementProperty;
    private ModelElementListener modelElementListener;
    private MasterDetailsContentNode parentNode;
    private FunctionResult labelFunctionResult;
    private Set<String> listProperties;
    private ImageDescriptor imageDescriptor;
    private ImageDescriptor imageDescriptorWithError;
    private ImageDescriptor imageDescriptorWithWarning;
    private SapphirePartListener childPartListener;
    private List<Object> rawChildren;
    private List<SapphireSection> sections;
    private List<SapphireSection> sectionsReadOnly;
    private boolean expanded;
    private SapphireCondition visibleWhenCondition;
    private final List<SapphireCondition> allConditions = new ArrayList<SapphireCondition>();
    private boolean transformLabelCase = true;

    @Override
    protected void init() {
        String hideIfDisabled;
        super.init();
        ISapphirePart parent = this.getParentPart();
        this.parentNode = parent instanceof MasterDetailsContentNode ? (MasterDetailsContentNode)parent : null;
        this.contentTree = this.getNearestPart(MasterDetailsPage.class).getContentTree();
        this.definition = (IMasterDetailsTreeNodeDef)((SapphirePart)this).definition;
        this.modelElementProperty = (ImpliedElementProperty)this.resolve((String)this.definition.getProperty().getContent());
        if (this.modelElementProperty != null) {
            this.modelElement = this.getModelElement().read(this.modelElementProperty);
            this.modelElementListener = new ModelElementListener(){

                public void propertyChanged(ModelPropertyChangeEvent event) {
                    MasterDetailsContentNode.this.handleModelElementChange(event);
                }
            };
            this.modelElement.addListener(this.modelElementListener);
        } else {
            this.modelElement = this.getModelElement();
        }
        this.labelFunctionResult = this.initExpression(this.modelElement, this.definition.getLabel(), new Runnable(){

            public void run() {
                MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
            }
        });
        this.imageDescriptor = (ImageDescriptor)this.definition.getImagePath().resolve();
        this.imageDescriptorWithError = null;
        this.imageDescriptorWithWarning = null;
        this.visibleWhenCondition = null;
        Class<SapphirePropertyEnabledCondition> visibleWhenConditionClass = null;
        String visibleWhenConditionParameter = null;
        IStatus visibleWhenConditionClassValidation = this.definition.getVisibleWhenConditionClass().validate();
        if (visibleWhenConditionClassValidation.getSeverity() != 4) {
            visibleWhenConditionClass = (Class<SapphirePropertyEnabledCondition>)this.definition.getVisibleWhenConditionClass().resolve();
            visibleWhenConditionParameter = this.definition.getVisibleWhenConditionParameter().getText();
        } else {
            SapphireUiFrameworkPlugin.log(visibleWhenConditionClassValidation);
        }
        if (visibleWhenConditionClass == null && this.modelElementProperty != null && Boolean.parseBoolean(hideIfDisabled = this.definition.getHint(HINT_HIDE_IF_DISABLED))) {
            visibleWhenConditionClass = SapphirePropertyEnabledCondition.class;
            visibleWhenConditionParameter = this.modelElementProperty.getName();
        }
        if (visibleWhenConditionClass != null) {
            this.visibleWhenCondition = SapphireCondition.create(this, visibleWhenConditionClass, visibleWhenConditionParameter);
            if (this.visibleWhenCondition != null) {
                this.allConditions.add(this.visibleWhenCondition);
                this.visibleWhenCondition.addListener(new SapphireCondition.Listener(){

                    public void handleConditionChanged() {
                        MasterDetailsContentNode.this.getContentTree().refresh();
                    }
                });
            }
        }
        this.expanded = false;
        this.childPartListener = new SapphirePartListener(){

            public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                MasterDetailsContentNode.this.updateValidationState();
            }
        };
        SapphirePartListener validationStateListener = new SapphirePartListener(){

            public void handleValidateStateChange(IStatus oldValidateState, IStatus newValidationState) {
                MasterDetailsContentNode.this.getContentTree().notifyOfNodeUpdate(MasterDetailsContentNode.this);
            }
        };
        this.addListener(validationStateListener);
        this.sections = new ArrayList<SapphireSection>();
        this.sectionsReadOnly = Collections.unmodifiableList(this.sections);
        for (ISapphireSectionDef secdef : this.definition.getSections()) {
            SapphireSection section = new SapphireSection();
            section.init(this, this.modelElement, secdef, Collections.<String, String>emptyMap());
            section.addListener(this.childPartListener);
            this.sections.add(section);
        }
        this.rawChildren = new ArrayList<Object>();
        for (Object entry : this.definition.getChildNodes()) {
            String parameter;
            IMasterDetailsTreeNodeListEntry def;
            if (entry instanceof IMasterDetailsTreeNodeDef || entry instanceof IMasterDetailsTreeNodeRef) {
                def = entry instanceof IMasterDetailsTreeNodeDef ? (IMasterDetailsTreeNodeDef)entry : ((IMasterDetailsTreeNodeRef)entry).resolve();
                MasterDetailsContentNode node = new MasterDetailsContentNode();
                node.init(this, this.modelElement, (ISapphirePartDef)((Object)def), this.params);
                node.addListener(this.childPartListener);
                this.rawChildren.add(node);
                continue;
            }
            if (!(entry instanceof IMasterDetailsTreeNodeFactoryDef) && !(entry instanceof IMasterDetailsTreeNodeFactoryRef)) continue;
            def = entry instanceof IMasterDetailsTreeNodeFactoryDef ? (IMasterDetailsTreeNodeFactoryDef)entry : ((IMasterDetailsTreeNodeFactoryRef)entry).resolve();
            ListProperty listProperty = (ListProperty)this.resolve(this.getLocalModelElement(), (String)def.getListProperty().getContent());
            SapphireCondition factoryVisibleWhenCondition = null;
            Class factoryVisibleWhenConditionClass = (Class)def.getVisibleWhenConditionClass().resolve();
            if (factoryVisibleWhenConditionClass != null && (factoryVisibleWhenCondition = SapphireCondition.create(this, factoryVisibleWhenConditionClass, parameter = def.getVisibleWhenConditionParameter().getText())) != null) {
                this.allConditions.add(factoryVisibleWhenCondition);
            }
            ListPropertyNodeFactory factory = new ListPropertyNodeFactory(this.modelElement, listProperty, factoryVisibleWhenCondition, (IMasterDetailsTreeNodeFactoryDef)def){
                private final /* synthetic */ IMasterDetailsTreeNodeFactoryDef val$def;
                {
                    this.val$def = iMasterDetailsTreeNodeFactoryDef;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                protected MasterDetailsContentNode createNode(IModelElement listEntryModelElement) {
                    IMasterDetailsTreeNodeFactoryEntry listEntryNodeDef = null;
                    for (IMasterDetailsTreeNodeFactoryEntry entry : this.val$def.getTypeSpecificDefinitions()) {
                        Class type = (Class)entry.getType().resolve();
                        if (type != null && !type.isAssignableFrom(listEntryModelElement.getClass())) continue;
                        listEntryNodeDef = entry;
                        break;
                    }
                    if (listEntryNodeDef == null) {
                        throw new RuntimeException();
                    }
                    MasterDetailsContentNode node = new MasterDetailsContentNode();
                    node.init(MasterDetailsContentNode.this, listEntryModelElement, listEntryNodeDef, MasterDetailsContentNode.this.params);
                    node.addListener(MasterDetailsContentNode.this.childPartListener);
                    node.transformLabelCase = false;
                    return node;
                }
            };
            this.rawChildren.add(factory);
        }
        this.listProperties = new HashSet<String>();
        for (Object entry : this.rawChildren) {
            if (!(entry instanceof ListPropertyNodeFactory)) continue;
            this.listProperties.add(((ListPropertyNodeFactory)entry).getListProperty().getName());
        }
    }

    public MasterDetailsContentTree getContentTree() {
        return this.contentTree;
    }

    public MasterDetailsContentNode getParentNode() {
        return this.parentNode;
    }

    public boolean isAncestorOf(MasterDetailsContentNode node) {
        MasterDetailsContentNode n = node;
        while (n != null) {
            if (n == this) {
                return true;
            }
            n = n.getParentNode();
        }
        return false;
    }

    public IModelElement getLocalModelElement() {
        return this.modelElement;
    }

    public String getLabel() {
        String label = null;
        if (this.labelFunctionResult != null) {
            label = (String)this.labelFunctionResult.value();
        }
        if (label == null) {
            label = "#null#";
        } else {
            label = label.trim();
            CapitalizationType capType = this.transformLabelCase ? CapitalizationType.TITLE_STYLE : CapitalizationType.NO_CAPS;
            label = ((LocalizationService)this.definition.adapt(LocalizationService.class)).transform(label, capType, false);
        }
        return label;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor base;
        IStatus st = this.getValidationState();
        int severity = st.getSeverity();
        if (((Boolean)this.definition.getUseModelElementImage().getContent()).booleanValue()) {
            Image img = this.getImageCache().getImage(this.getLocalModelElement());
            base = ImageDescriptor.createFromImage((Image)img);
        } else {
            base = this.imageDescriptor;
        }
        if (base == null) {
            if (severity == 4) {
                if (this.hasChildNodes()) {
                    return IMG_DESC_CONTAINER_WITH_ERROR;
                }
                return IMG_DESC_LEAF_WITH_ERROR;
            }
            if (severity == 2) {
                if (this.hasChildNodes()) {
                    return IMG_DESC_CONTAINER_WITH_WARNING;
                }
                return IMG_DESC_LEAF_WITH_WARNING;
            }
            if (this.hasChildNodes()) {
                return IMG_DESC_CONTAINER;
            }
            return IMG_DESC_LEAF;
        }
        if (severity == 4) {
            if (this.imageDescriptorWithError == null) {
                this.imageDescriptorWithError = new ProblemOverlayImageDescriptor(base, 4);
            }
            return this.imageDescriptorWithError;
        }
        if (severity == 2) {
            if (this.imageDescriptorWithWarning == null) {
                this.imageDescriptorWithWarning = new ProblemOverlayImageDescriptor(base, 2);
            }
            return this.imageDescriptorWithWarning;
        }
        return base;
    }

    public boolean isVisible() {
        if (this.visibleWhenCondition != null) {
            return this.visibleWhenCondition.getConditionState();
        }
        return true;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, false);
    }

    public void setExpanded(boolean expanded, boolean applyToChildren) {
        if (this.parentNode != null && !this.parentNode.isExpanded() && expanded) {
            this.parentNode.setExpanded(true);
        }
        if (this.expanded != expanded) {
            MasterDetailsContentNode selection;
            if (!expanded && (selection = this.getContentTree().getSelectedNode()) != null && this.isAncestorOf(selection)) {
                this.select();
            }
            if (expanded) {
                this.expanded = expanded;
                this.getContentTree().notifyOfNodeExpandedStateChange(this);
            }
        }
        if (applyToChildren) {
            for (MasterDetailsContentNode child : this.getChildNodes()) {
                if (!child.hasChildNodes()) continue;
                child.setExpanded(expanded, applyToChildren);
            }
        }
        if (this.expanded != expanded && !expanded) {
            this.expanded = expanded;
            this.getContentTree().notifyOfNodeExpandedStateChange(this);
        }
    }

    public List<MasterDetailsContentNode> getExpandedNodes() {
        ArrayList<MasterDetailsContentNode> result = new ArrayList<MasterDetailsContentNode>();
        this.getExpandedNodes(result);
        return result;
    }

    public void getExpandedNodes(List<MasterDetailsContentNode> result) {
        if (this.isExpanded()) {
            result.add(this);
            for (MasterDetailsContentNode child : this.getChildNodes()) {
                child.getExpandedNodes(result);
            }
        }
    }

    public void select() {
        this.getContentTree().setSelectedNode(this);
    }

    public List<SapphireSection> getSections() {
        return this.sectionsReadOnly;
    }

    public List<ListProperty> getChildListProperties() {
        ArrayList<ListProperty> listProperties = new ArrayList<ListProperty>();
        for (Object object : this.rawChildren) {
            ListPropertyNodeFactory factory;
            if (!(object instanceof ListPropertyNodeFactory) || !(factory = (ListPropertyNodeFactory)object).isVisible()) continue;
            listProperties.add(factory.getListProperty());
        }
        return listProperties;
    }

    public boolean hasChildNodes() {
        return !this.rawChildren.isEmpty();
    }

    public List<MasterDetailsContentNode> getChildNodes() {
        ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
        for (Object entry : this.rawChildren) {
            if (entry instanceof MasterDetailsContentNode) {
                MasterDetailsContentNode node = (MasterDetailsContentNode)entry;
                if (!node.isVisible()) continue;
                nodes.add(node);
                continue;
            }
            if (entry instanceof ListPropertyNodeFactory) {
                ListPropertyNodeFactory factory = (ListPropertyNodeFactory)entry;
                if (!factory.isVisible()) continue;
                nodes.addAll(factory.createNodes());
                continue;
            }
            throw new IllegalStateException(entry.getClass().getName());
        }
        return nodes;
    }

    public MasterDetailsContentNode getChildNodeByLabel(String label) {
        for (MasterDetailsContentNode child : this.getChildNodes()) {
            if (!label.equals(child.getLabel())) continue;
            return child;
        }
        return null;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.EditorPage.Outline.Node");
    }

    @Override
    protected IStatus computeValidationState() {
        SapphireMultiStatus st = new SapphireMultiStatus();
        for (SapphirePart sapphirePart : this.sections) {
            st.add(sapphirePart.getValidationState());
        }
        for (SapphirePart sapphirePart : this.getChildNodes()) {
            st.add(sapphirePart.getValidationState());
        }
        return st;
    }

    @Override
    protected void handleModelElementChange(ModelPropertyChangeEvent event) {
        super.handleModelElementChange(event);
        ModelProperty property = event.getProperty();
        if (this.listProperties != null && this.listProperties.contains(property.getName())) {
            Runnable notifyOfStructureChangeOperation = new Runnable(){

                public void run() {
                    MasterDetailsContentNode.this.getContentTree().notifyOfNodeStructureChange(MasterDetailsContentNode.this);
                    MasterDetailsContentNode.this.updateValidationState();
                }
            };
            Display.getDefault().asyncExec(notifyOfStructureChangeOperation);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.modelElementListener != null) {
            this.modelElement.removeListener(this.modelElementListener);
        }
        for (SapphirePart sapphirePart : this.sections) {
            sapphirePart.dispose();
        }
        for (SapphirePart sapphirePart : this.getChildNodes()) {
            sapphirePart.dispose();
        }
        for (SapphireCondition sapphireCondition : this.allConditions) {
            sapphireCondition.dispose();
        }
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }
}

