/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.HtmlContent;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.renderers.swt.ValuePropertyEditorRenderer;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class HtmlPropertyEditorRenderer
extends ValuePropertyEditorRenderer {
    private Browser browser;

    public HtmlPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        SapphirePropertyEditor part = this.getPart();
        ValueProperty property = (ValueProperty)part.getProperty();
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", !showLabelAbove);
        Label label = null;
        int baseIndent = part.getLeftMarginHint() + 9;
        if (showLabelInline || showLabelAbove) {
            label = new Label(parent, 0);
            label.setText(String.valueOf(property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":");
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), showLabelAbove ? 2 : 1), baseIndent));
            this.context.adapt((Control)label);
        }
        this.setSpanBothColumns(!showLabelInline);
        Composite composite = this.createMainComposite(parent);
        composite.setLayout((Layout)GridLayoutUtil.glayout(1, 9, 0, 0, 0));
        this.browser = new Browser(composite, 2048);
        this.browser.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.addControl((Control)this.browser);
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        String newHtmlContent = this.getPropertyValue().getText();
        if (newHtmlContent == null) {
            newHtmlContent = "";
        }
        if (!newHtmlContent.equals(this.browser.getText())) {
            this.browser.setText(newHtmlContent);
        }
    }

    protected void handleFocusReceivedEvent() {
        this.browser.setFocus();
    }

    protected boolean canExpandVertically() {
        return true;
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            ModelProperty property = propertyEditorDefinition.getProperty();
            return property instanceof ValueProperty && property.hasAnnotation(HtmlContent.class);
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new HtmlPropertyEditorRenderer(context, part);
        }
    }
}

