/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public final class SapphireStatusDialog
extends Dialog {
    private final IStatus status;
    private TreeViewer treeViewer;
    private Tree tree;

    private SapphireStatusDialog(Shell shell, IStatus status) {
        super(shell);
        this.status = status;
    }

    public static void open(Shell shell, IStatus status) {
        if (status.isMultiStatus()) {
            new SapphireStatusDialog(shell, status).open();
        } else if (status.getSeverity() == 4) {
            MessageDialog.openError((Shell)shell, (String)Resources.errorDialogTitle, (String)status.getMessage());
        } else {
            MessageDialog.openWarning((Shell)shell, (String)Resources.warningDialogTitle, (String)status.getMessage());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Resources.problemsDialogTitle);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 10, 10), 10));
        Label imageLabel = new Label(composite, 0);
        imageLabel.setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        if (this.status.getSeverity() == 4) {
            imageLabel.setImage(this.getShell().getDisplay().getSystemImage(1));
        } else {
            imageLabel.setImage(this.getShell().getDisplay().getSystemImage(8));
        }
        this.treeViewer = new TreeViewer(composite, 2050);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhhint(GridLayoutUtil.gdfill(), 100), 400));
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getElements(Object input) {
                return SapphireStatusDialog.this.status.getChildren();
            }

            public Object[] getChildren(Object element) {
                return ((IStatus)element).getChildren();
            }

            public boolean hasChildren(Object element) {
                return ((IStatus)element).getChildren().length > 0;
            }

            public Object getParent(Object element) {
                return this.findParent(null, SapphireStatusDialog.this.status.getChildren(), (IStatus)element);
            }

            private IStatus findParent(IStatus parent, IStatus[] children, IStatus element) {
                IStatus[] iStatusArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    if (child == element) {
                        return parent;
                    }
                    IStatus result = this.findParent(child, child.getChildren(), element);
                    if (result != null) {
                        return result;
                    }
                    ++n2;
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ILabelProvider labelProvider = new ILabelProvider(){

            public String getText(Object element) {
                return ((IStatus)element).getMessage();
            }

            public Image getImage(Object element) {
                if (((IStatus)element).getSeverity() == 4) {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
                return sharedImages.getImage("IMG_OBJS_WARN_TSK");
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }
        };
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)this);
        Menu menu = new Menu((Control)this.tree);
        this.tree.setMenu(menu);
        MenuItem copyMenuItem = new MenuItem(menu, 8);
        copyMenuItem.setText(Resources.copyMenuItem);
        copyMenuItem.setImage(sharedImages.getImage("IMG_TOOL_COPY"));
        copyMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SapphireStatusDialog.this.copySelectionToClipboard();
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }

    private void copySelectionToClipboard() {
        StringBuilder buf = new StringBuilder();
        String nl = System.getProperty("line.separator");
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        for (IStatus st : selection) {
            if (buf.length() > 0) {
                buf.append(nl);
            }
            buf.append(st.getSeverity() == 4 ? Resources.errorMessagePrefix : Resources.warningMessagePrefix);
            buf.append(' ');
            buf.append(st.getMessage());
        }
        String text = buf.toString();
        if (text.length() > 0) {
            Clipboard clipboard = new Clipboard(this.tree.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{text}, new Transfer[]{textTransfer});
        }
    }

    private static final class Resources
    extends NLS {
        public static String errorDialogTitle;
        public static String warningDialogTitle;
        public static String problemsDialogTitle;
        public static String errorMessagePrefix;
        public static String warningMessagePrefix;
        public static String copyMenuItem;

        static {
            Resources.initializeMessages((String)SapphireStatusDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

