/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;

public final class OutlineNodeDeleteActionHandler
extends SapphireActionHandler {
    public static final String ID = "Sapphire.Outline.Delete";

    public OutlineNodeDeleteActionHandler() {
        this.setId(ID);
    }

    protected Object run(SapphireRenderingContext context) {
        List<MasterDetailsContentNode> nodes;
        ISapphirePart part = this.getPart();
        if (part instanceof MasterDetailsContentNode) {
            nodes = Collections.singletonList((MasterDetailsContentNode)part);
        } else if (part instanceof MasterDetailsPage) {
            nodes = ((MasterDetailsPage)part).getContentTree().getSelectedNodes();
        } else {
            throw new IllegalStateException();
        }
        MasterDetailsContentNode newSelection = null;
        MasterDetailsContentNode parent = nodes.get(0).getParentNode();
        List<MasterDetailsContentNode> siblings = parent.getChildNodes();
        int size = siblings.size();
        if (size == nodes.size()) {
            newSelection = parent;
        } else {
            int lowestIndexOfRemovedNode = -1;
            for (MasterDetailsContentNode node : nodes) {
                int indexOfRemovedNode = siblings.indexOf(node);
                if (indexOfRemovedNode == -1) continue;
                lowestIndexOfRemovedNode = lowestIndexOfRemovedNode == -1 ? indexOfRemovedNode : Math.min(lowestIndexOfRemovedNode, indexOfRemovedNode);
            }
            if (lowestIndexOfRemovedNode != -1) {
                int indexOfNewSelection = -1;
                if (lowestIndexOfRemovedNode == 0) {
                    int i = 0;
                    while (i < size) {
                        MasterDetailsContentNode node = siblings.get(i);
                        if (!nodes.contains(node)) {
                            indexOfNewSelection = i;
                            break;
                        }
                        ++i;
                    }
                } else {
                    indexOfNewSelection = lowestIndexOfRemovedNode - 1;
                }
                if (indexOfNewSelection != -1) {
                    newSelection = siblings.get(indexOfNewSelection);
                }
            }
        }
        for (MasterDetailsContentNode node : nodes) {
            IModelElement element = node.getModelElement();
            ModelElementList list = (ModelElementList)element.parent();
            list.remove((Object)element);
        }
        if (newSelection != null) {
            newSelection.getContentTree().setSelectedNode(newSelection);
        }
        return null;
    }
}

