/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions.internal;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.BasePathsProvider;
import org.eclipse.sapphire.modeling.annotations.BasePathsProviderImpl;
import org.eclipse.sapphire.ui.SapphireJumpActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelativePathJumpActionHandler
extends SapphireJumpActionHandler {
    public static final String ID = "Sapphire.Jump.Path.Relative";

    public RelativePathJumpActionHandler() {
        this.setId(ID);
    }

    @Override
    protected void refreshEnablementState() {
        ValueProperty property;
        IModelElement element = this.getModelElement();
        String relativePath = element.read(property = this.getProperty()).getText(true);
        if (relativePath != null) {
            for (IPath basePath : this.getBasePaths(element, (ModelProperty)property)) {
                IPath absolutePath = basePath.append(relativePath);
                File absoluteFile = absolutePath.toFile();
                if (!absoluteFile.exists() || !absoluteFile.isFile()) continue;
                this.setEnabled(true);
            }
        }
        this.setEnabled(false);
    }

    @Override
    protected Object run(SapphireRenderingContext context) {
        ValueProperty property;
        IModelElement element = this.getModelElement();
        String relativePath = element.read(property = this.getProperty()).getText(true);
        if (relativePath != null) {
            IWorkbenchWindow window;
            File file = null;
            for (IPath basePath : this.getBasePaths(element, (ModelProperty)property)) {
                IPath absolutePath = basePath.append(relativePath);
                File absoluteFile = absolutePath.toFile();
                if (!absoluteFile.exists() || !absoluteFile.isFile()) continue;
                file = absoluteFile;
                break;
            }
            if (file != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                IWorkbenchPage page = window.getActivePage();
                IEditorDescriptor editorDescriptor = null;
                try {
                    editorDescriptor = IDE.getEditorDescriptor((String)file.getName());
                }
                catch (PartInitException partInitException) {}
                if (editorDescriptor != null) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)editorDescriptor.getId(), (boolean)true);
                    }
                    catch (PartInitException e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
            }
        }
        return null;
    }

    private List<IPath> getBasePaths(IModelElement modelElement, ModelProperty property) {
        BasePathsProviderImpl basePathsProvider;
        BasePathsProvider basePathsProviderAnnotation = (BasePathsProvider)property.getAnnotation(BasePathsProvider.class);
        Class basePathsProviderClass = basePathsProviderAnnotation.value();
        try {
            basePathsProvider = (BasePathsProviderImpl)basePathsProviderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return basePathsProvider.getBasePaths(modelElement);
    }
}

