/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.extensibility.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.extensibility.IModelElementServiceDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementServiceDef
extends ModelElement
implements IModelElementServiceDef {
    private Value<String> description;
    private ReferenceValue<Class<?>> factoryClass;
    private ReferenceValue<Class<?>> typeClass;

    public ModelElementServiceDef(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ModelElementServiceDef(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!ModelElementServiceDef.equal((String)this.description.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<Class<?>> getFactoryClass() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.factoryClass == null) {
                this.refresh((ModelProperty)PROP_FACTORY_CLASS, true);
            }
            return this.factoryClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFactoryClass(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_FACTORY_CLASS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_FACTORY_CLASS, true);
            if (!ModelElementServiceDef.equal((String)this.factoryClass.getText(false), (String)value)) {
                this.resource().binding(PROP_FACTORY_CLASS).write(value);
                this.refresh((ModelProperty)PROP_FACTORY_CLASS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<Class<?>> getTypeClass() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.typeClass == null) {
                this.refresh((ModelProperty)PROP_TYPE_CLASS, true);
            }
            return this.typeClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeClass(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_TYPE_CLASS.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_TYPE_CLASS, true);
            if (!ModelElementServiceDef.equal((String)this.typeClass.getText(false), (String)value)) {
                this.resource().binding(PROP_TYPE_CLASS).write(value);
                this.refresh((ModelProperty)PROP_TYPE_CLASS, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DESCRIPTION) {
                if (this.description != null || force) {
                    Value<String> oldValue = this.description;
                    String val = this.resource().binding(PROP_DESCRIPTION).read();
                    this.description = new Value((IModelElement)this, PROP_DESCRIPTION, PROP_DESCRIPTION.encodeKeywords(val));
                    this.description.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue != null) {
                        if (this.description.equals(oldValue)) {
                            this.description = oldValue;
                        }
                        if (this.description != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_DESCRIPTION);
                        }
                    }
                }
            } else if (property == PROP_FACTORY_CLASS) {
                if (this.factoryClass != null || force) {
                    ReferenceValue<Class<?>> oldValue = this.factoryClass;
                    String val = this.resource().binding(PROP_FACTORY_CLASS).read();
                    this.factoryClass = new ReferenceValue((IModelElement)this, PROP_FACTORY_CLASS, PROP_FACTORY_CLASS.encodeKeywords(val));
                    this.factoryClass.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_FACTORY_CLASS);
                    if (oldValue != null) {
                        if (this.factoryClass.equals(oldValue)) {
                            this.factoryClass = oldValue;
                        }
                        if (this.factoryClass != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_FACTORY_CLASS);
                        }
                    }
                }
            } else if (property == PROP_TYPE_CLASS && (this.typeClass != null || force)) {
                ReferenceValue<Class<?>> oldValue = this.typeClass;
                String val = this.resource().binding(PROP_TYPE_CLASS).read();
                this.typeClass = new ReferenceValue((IModelElement)this, PROP_TYPE_CLASS, PROP_TYPE_CLASS.encodeKeywords(val));
                this.typeClass.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_TYPE_CLASS);
                if (oldValue != null) {
                    if (this.typeClass.equals(oldValue)) {
                        this.typeClass = oldValue;
                    }
                    if (this.typeClass != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_TYPE_CLASS);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        if (property == PROP_FACTORY_CLASS) {
            return this.getFactoryClass();
        }
        if (property == PROP_TYPE_CLASS) {
            return this.getTypeClass();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        if (property == PROP_FACTORY_CLASS) {
            this.setFactoryClass((String)value);
            return;
        }
        if (property == PROP_TYPE_CLASS) {
            this.setTypeClass((String)value);
            return;
        }
        super.write(property, value);
    }
}

