/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validators;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.BasePathsProvider;
import org.eclipse.sapphire.modeling.annotations.BasePathsProviderImpl;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.validators.PathValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativePathValueValidator
extends PathValueValidator {
    private final BasePathsProviderImpl basePathsProvider;

    public RelativePathValueValidator(ValueProperty property) {
        super(property);
        BasePathsProvider basePathsProviderAnnotation = property.getAnnotation(BasePathsProvider.class);
        Class<? extends BasePathsProviderImpl> basePathsProviderClass = basePathsProviderAnnotation.value();
        try {
            this.basePathsProvider = basePathsProviderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IStatus validate(Value<IPath> value) {
        IPath path = value.getContent();
        if (path != null) {
            List<IPath> basePaths = this.basePathsProvider.getBasePaths(value.parent());
            for (IPath basePath : basePaths) {
                IPath absolutePath = basePath.append(path);
                File absolutePathFile = absolutePath.toFile();
                if (!absolutePathFile.exists()) continue;
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    if (absolutePathFile.isFile()) {
                        return this.validateExtensions(path);
                    }
                    String message = NLS.bind((String)PathValueValidator.Resources.pathIsNotFile, (Object)absolutePath.toPortableString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER && !absolutePathFile.isDirectory()) {
                    String message = NLS.bind((String)PathValueValidator.Resources.pathIsNotFolder, (Object)absolutePath.toPortableString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                return Status.OK_STATUS;
            }
            if (this.resourceMustExist) {
                String message;
                if (this.validResourceType == FileSystemResourceType.FILE) {
                    message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.fileMustExist, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                if (this.validResourceType == FileSystemResourceType.FOLDER) {
                    message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.folderMustExist, (Object)path.toString());
                    return new Status(4, "org.eclipse.sapphire.modeling", message);
                }
                message = PathValueValidator.Resources.bind((String)PathValueValidator.Resources.resourceMustExist, (Object)path.toString());
                return new Status(4, "org.eclipse.sapphire.modeling", message);
            }
        }
        return Status.OK_STATUS;
    }
}

