/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.util.internal.DocumentationUtil;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XmlNode {
    private final XmlResourceStore store;
    private final XmlElement parent;
    private final Node domNode;

    public XmlNode(XmlResourceStore store, XmlElement parent, Node domNode) {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        if (domNode == null) {
            throw new IllegalArgumentException();
        }
        this.store = store;
        this.parent = parent;
        this.domNode = domNode;
    }

    public final XmlResourceStore getResourceStore() {
        return this.store;
    }

    public final XmlElement getParent() {
        return this.parent;
    }

    public Node getDomNode() {
        return this.domNode;
    }

    public final void validateEdit() throws ValidateEditException {
        this.store.validateEdit();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof XmlNode) {
            return this.domNode == ((XmlNode)obj).domNode;
        }
        return false;
    }

    public final int hashCode() {
        return this.domNode.hashCode();
    }

    public final String getText() {
        return this.getText(false);
    }

    public final String getText(boolean removeExtraWhitespace) {
        String text = this.getTextInternal().trim();
        if (removeExtraWhitespace) {
            return DocumentationUtil.collapseString(text);
        }
        return text;
    }

    protected abstract String getTextInternal();

    public abstract void setText(String var1);

    public final String toString() {
        try {
            StringWriter sw = new StringWriter();
            DOMSource source = new DOMSource(this.domNode);
            StreamResult result = new StreamResult(sw);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.toString();
        }
    }

    public final void format() {
        this.validateEdit();
        this.removeFormatting();
        int depth = 0;
        if (this.domNode.getParentNode() != null) {
            Node n = this.domNode.getParentNode();
            while (n.getNodeType() == 1) {
                ++depth;
                n = n.getParentNode();
            }
        }
        this.format(depth);
    }

    private void format(int depth) {
        StringBuilder buf = new StringBuilder();
        buf.append('\n');
        int i = 0;
        while (i < depth) {
            buf.append("    ");
            ++i;
        }
        String formatting = buf.toString();
        Document document = this.domNode.getOwnerDocument();
        Node parent = this.domNode.getParentNode();
        if (parent.getNodeType() == 1 || parent.getNodeType() == 9) {
            Text textBeforeOpeningTag = document.createTextNode(formatting);
            parent.insertBefore(textBeforeOpeningTag, this.domNode);
        }
        if (this.domNode.getNodeType() == 1 && this.domNode.getChildNodes().getLength() > 0) {
            Text textBeforeClosingTag = document.createTextNode(formatting);
            this.domNode.appendChild(textBeforeClosingTag);
        }
        if (this instanceof XmlElement) {
            int depthPlusOne = depth + 1;
            XmlElement element = (XmlElement)this;
            for (XmlNode xmlNode : element.getChildElements()) {
                xmlNode.format(depthPlusOne);
            }
            for (XmlNode xmlNode : element.getComments()) {
                xmlNode.format(depthPlusOne);
            }
        }
    }

    public final void removeFormatting() {
        Node prevSibling;
        this.validateEdit();
        NodeList nodes = this.domNode.getChildNodes();
        ArrayList<Node> textNodesToRemove = new ArrayList<Node>();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node child = nodes.item(i);
            if (child.getNodeType() == 3 && child.getNodeValue().trim().length() == 0) {
                textNodesToRemove.add(child);
            }
            ++i;
        }
        for (Node n2 : textNodesToRemove) {
            this.domNode.removeChild(n2);
        }
        if (this instanceof XmlElement) {
            XmlElement element = (XmlElement)this;
            for (XmlNode xmlNode : element.getChildElements()) {
                xmlNode.removeFormatting();
            }
            for (XmlNode xmlNode : element.getComments()) {
                xmlNode.removeFormatting();
            }
        }
        if ((prevSibling = this.domNode.getPreviousSibling()) != null && prevSibling.getNodeType() == 3 && prevSibling.getNodeValue().trim().length() == 0) {
            this.domNode.getParentNode().removeChild(prevSibling);
        }
    }

    public abstract void remove();
}

