/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import java.util.List;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.samples.calendar.integrated.IAttendee;
import org.eclipse.sapphire.samples.calendar.ui.CalendarEditor;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.ui.SapphireJumpActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContactDetailsJumpHandler
extends SapphireJumpActionHandler {
    protected void initDependencies(List<String> dependencies) {
        super.initDependencies(dependencies);
        dependencies.add(IAttendee.PROP_IN_CONTACTS_DATABASE.getName());
    }

    protected void refreshEnablementState() {
        IAttendee attendee = (IAttendee)this.getModelElement();
        this.setEnabled((Boolean)attendee.isInContactsDatabase().getContent());
    }

    protected Object run(SapphireRenderingContext context) {
        CalendarEditor editor = (CalendarEditor)((Object)context.getPart().getNearestPart(CalendarEditor.class));
        ContactDetailsJumpHandler.jump(editor, this.getModelElement());
        return null;
    }

    public static void jump(CalendarEditor editor, IModelElement modelElement) {
        IAttendee attendee = (IAttendee)modelElement;
        String name = attendee.getName().getText();
        if (name != null) {
            MasterDetailsPage contactsFormPage;
            MasterDetailsContentTree content;
            MasterDetailsContentNode contactNode;
            IContact contact = null;
            for (IContact c : editor.getContactsDatabase().getContacts()) {
                if (!name.equals(c.getName().getText())) continue;
                contact = c;
                break;
            }
            if (contact != null && (contactNode = ContactDetailsJumpHandler.findContactNode((content = (contactsFormPage = (MasterDetailsPage)editor.getPage("Contacts")).getContentTree()).getRoot(), contact)) != null) {
                contactNode.select();
                editor.showPage("Contacts");
            }
        }
    }

    private static MasterDetailsContentNode findContactNode(MasterDetailsContentNode node, IContact contact) {
        if (node.getModelElement() == contact) {
            return node;
        }
        for (MasterDetailsContentNode child : node.getChildNodes()) {
            MasterDetailsContentNode res = ContactDetailsJumpHandler.findContactNode(child, contact);
            if (res == null) continue;
            return res;
        }
        return null;
    }
}

