/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlElementBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.samples.contacts.IAddress;
import org.eclipse.sapphire.samples.contacts.IAssistant;
import org.eclipse.sapphire.samples.contacts.IConnection;
import org.eclipse.sapphire.samples.contacts.IHomemakerOccupation;
import org.eclipse.sapphire.samples.contacts.IJobOccupation;
import org.eclipse.sapphire.samples.contacts.IOccupation;
import org.eclipse.sapphire.samples.contacts.IPhoneNumber;
import org.eclipse.sapphire.samples.contacts.IStudentOccupation;
import org.eclipse.sapphire.samples.contacts.IWebSite;
import org.eclipse.sapphire.samples.contacts.internal.ConnectionsListController;
import org.eclipse.sapphire.samples.contacts.internal.ContactCategoryValuesProvider;
import org.eclipse.sapphire.samples.contacts.internal.ContactMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Image(small="org.eclipse.sapphire.samples/images/person.png")
@GenerateImpl
public interface IContact
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(IContact.class);
    @Label(standard="name")
    @NonNullValue
    @NoDuplicates
    @XmlBinding(path="@name")
    public static final ValueProperty PROP_NAME = new ValueProperty(TYPE, "Name");
    @Label(standard="category")
    @DefaultValue(text="Personal")
    @PossibleValues(service=ContactCategoryValuesProvider.class)
    @XmlBinding(path="%category")
    @Documentation(content="This would be the help content for the category property.")
    public static final ValueProperty PROP_CATEGORY = new ValueProperty(TYPE, "Category");
    @Label(standard="E-Mail")
    @XmlBinding(path="e-mail")
    public static final ValueProperty PROP_E_MAIL = new ValueProperty(TYPE, "EMail");
    @Type(base=IPhoneNumber.class)
    @Label(standard="phone numbers")
    @XmlListBinding(path="phone-numbers", mappings={@XmlListBinding.Mapping(element="phone-number", type=IPhoneNumber.class)})
    public static final ListProperty PROP_PHONE_NUMBERS = new ListProperty(TYPE, "PhoneNumbers");
    @Type(base=IWebSite.class)
    @Label(standard="web sites")
    @XmlListBinding(path="web-sites", mappings={@XmlListBinding.Mapping(element="web-site", type=IWebSite.class)})
    public static final ListProperty PROP_WEB_SITES = new ListProperty(TYPE, "WebSites");
    @Type(base=IAddress.class)
    @XmlBinding(path="address")
    public static final ImpliedElementProperty PROP_ADDRESS = new ImpliedElementProperty(TYPE, "Address");
    @Type(base=IAssistant.class)
    @Label(standard="assistant")
    @XmlBinding(path="assistant")
    public static final ElementProperty PROP_ASSISTANT = new ElementProperty(TYPE, "Assistant");
    @Label(standard="connections")
    @Type(base=IConnection.class)
    @CustomXmlListBinding(impl=ConnectionsListController.class)
    public static final ListProperty PROP_CONNECTIONS = new ListProperty(TYPE, "Connections");
    @Type(base=IOccupation.class, possible={IJobOccupation.class, IStudentOccupation.class, IHomemakerOccupation.class})
    @Label(standard="primary occupation")
    @XmlElementBinding(path="primary-occupation", mappings={@XmlElementBinding.Mapping(element="job", type=IJobOccupation.class), @XmlElementBinding.Mapping(element="student", type=IStudentOccupation.class), @XmlElementBinding.Mapping(element="homemaker", type=IHomemakerOccupation.class)})
    public static final ElementProperty PROP_PRIMARY_OCCUPATION = new ElementProperty(TYPE, "PrimaryOccupation");

    public Value<String> getName();

    public void setName(String var1);

    public Value<String> getCategory();

    public void setCategory(String var1);

    public Value<String> getEMail();

    public void setEMail(String var1);

    public ModelElementList<IPhoneNumber> getPhoneNumbers();

    public ModelElementList<IWebSite> getWebSites();

    @DelegateImplementation(value=ContactMethods.class)
    public void removePhoneNumbersByAreaCode(String var1);

    public IAddress getAddress();

    public ModelElementHandle<IAssistant> getAssistant();

    public ModelElementList<IConnection> getConnections();

    public ModelElementHandle<IOccupation> getPrimaryOccupation();
}

