/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.contacts.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.contacts.IAddress;
import org.eclipse.sapphire.samples.contacts.IAssistant;
import org.eclipse.sapphire.samples.contacts.IConnection;
import org.eclipse.sapphire.samples.contacts.IContact;
import org.eclipse.sapphire.samples.contacts.IOccupation;
import org.eclipse.sapphire.samples.contacts.IPhoneNumber;
import org.eclipse.sapphire.samples.contacts.IWebSite;
import org.eclipse.sapphire.samples.contacts.internal.ContactMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Contact
extends ModelElement
implements IContact {
    private ModelElementHandle<IAddress> address;
    private ModelElementHandle<IAssistant> assistant;
    private Value<String> category;
    private ModelElementList<IConnection> connections;
    private Value<String> eMail;
    private Value<String> name;
    private ModelElementList<IPhoneNumber> phoneNumbers;
    private ModelElementHandle<IOccupation> primaryOccupation;
    private ModelElementList<IWebSite> webSites;

    public Contact(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Contact(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAddress getAddress() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.address == null) {
                this.refresh((ModelProperty)PROP_ADDRESS, true);
            }
            return (IAddress)this.address.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<IAssistant> getAssistant() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.assistant == null) {
                this.refresh((ModelProperty)PROP_ASSISTANT, true);
            }
            return this.assistant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getCategory() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.category == null) {
                this.refresh((ModelProperty)PROP_CATEGORY, true);
            }
            return this.category;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCategory(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_CATEGORY.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_CATEGORY, true);
            if (!Contact.equal((String)this.category.getText(false), (String)value)) {
                this.resource().binding(PROP_CATEGORY).write(value);
                this.refresh((ModelProperty)PROP_CATEGORY, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IConnection> getConnections() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.connections == null) {
                this.refresh((ModelProperty)PROP_CONNECTIONS, true);
            }
            return this.connections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getEMail() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.eMail == null) {
                this.refresh((ModelProperty)PROP_E_MAIL, true);
            }
            return this.eMail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEMail(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_E_MAIL.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_E_MAIL, true);
            if (!Contact.equal((String)this.eMail.getText(false), (String)value)) {
                this.resource().binding(PROP_E_MAIL).write(value);
                this.refresh((ModelProperty)PROP_E_MAIL, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Contact.equal((String)this.name.getText(false), (String)value)) {
                this.resource().binding(PROP_NAME).write(value);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IPhoneNumber> getPhoneNumbers() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.phoneNumbers == null) {
                this.refresh((ModelProperty)PROP_PHONE_NUMBERS, true);
            }
            return this.phoneNumbers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<IOccupation> getPrimaryOccupation() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.primaryOccupation == null) {
                this.refresh((ModelProperty)PROP_PRIMARY_OCCUPATION, true);
            }
            return this.primaryOccupation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IWebSite> getWebSites() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.webSites == null) {
                this.refresh((ModelProperty)PROP_WEB_SITES, true);
            }
            return this.webSites;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePhoneNumbersByAreaCode(String areaCode) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ContactMethods.removePhoneNumbersByAreaCode(this, areaCode);
        }
    }

    public boolean isPropertyEnabled(ModelProperty property) {
        if (property == PROP_ADDRESS) {
            if (this.address == null) {
                this.refresh((ModelProperty)PROP_ADDRESS, true);
            }
            return this.address.enabled();
        }
        if (property == PROP_ASSISTANT) {
            if (this.assistant == null) {
                this.refresh((ModelProperty)PROP_ASSISTANT, true);
            }
            return this.assistant.enabled();
        }
        if (property == PROP_PRIMARY_OCCUPATION) {
            if (this.primaryOccupation == null) {
                this.refresh((ModelProperty)PROP_PRIMARY_OCCUPATION, true);
            }
            return this.primaryOccupation.enabled();
        }
        return super.isPropertyEnabled(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_ADDRESS) {
                if (this.address == null) {
                    if (force) {
                        this.address = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_ADDRESS);
                        this.address.init();
                    }
                } else {
                    this.address.refresh();
                }
            } else if (property == PROP_ASSISTANT) {
                if (this.assistant == null) {
                    if (force) {
                        this.assistant = new ModelElementHandle((IModelElement)this, PROP_ASSISTANT);
                        this.assistant.init();
                    }
                } else {
                    this.assistant.refresh();
                }
            } else if (property == PROP_CATEGORY) {
                if (this.category != null || force) {
                    Value<String> oldValue = this.category;
                    String val = this.resource().binding(PROP_CATEGORY).read();
                    this.category = new Value((IModelElement)this, PROP_CATEGORY, PROP_CATEGORY.encodeKeywords(val));
                    this.category.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CATEGORY);
                    if (oldValue != null) {
                        if (this.category.equals(oldValue)) {
                            this.category = oldValue;
                        }
                        if (this.category != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_CATEGORY);
                        }
                    }
                }
            } else if (property == PROP_CONNECTIONS) {
                if (this.connections == null) {
                    if (force) {
                        this.connections = new ModelElementList((IModelElement)this, PROP_CONNECTIONS);
                        ListBindingImpl binding = this.resource().binding(PROP_CONNECTIONS);
                        this.connections.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_CONNECTIONS);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_CONNECTIONS);
                    boolean notified = this.connections.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_CONNECTIONS);
                    }
                }
            } else if (property == PROP_E_MAIL) {
                if (this.eMail != null || force) {
                    Value<String> oldValue = this.eMail;
                    String val = this.resource().binding(PROP_E_MAIL).read();
                    this.eMail = new Value((IModelElement)this, PROP_E_MAIL, PROP_E_MAIL.encodeKeywords(val));
                    this.eMail.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_E_MAIL);
                    if (oldValue != null) {
                        if (this.eMail.equals(oldValue)) {
                            this.eMail = oldValue;
                        }
                        if (this.eMail != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_E_MAIL);
                        }
                    }
                }
            } else if (property == PROP_NAME) {
                if (this.name != null || force) {
                    Value<String> oldValue = this.name;
                    String val = this.resource().binding(PROP_NAME).read();
                    this.name = new Value((IModelElement)this, PROP_NAME, PROP_NAME.encodeKeywords(val));
                    this.name.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_NAME);
                    if (oldValue != null) {
                        if (this.name.equals(oldValue)) {
                            this.name = oldValue;
                        }
                        if (this.name != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME);
                        }
                    }
                }
            } else if (property == PROP_PHONE_NUMBERS) {
                if (this.phoneNumbers == null) {
                    if (force) {
                        this.phoneNumbers = new ModelElementList((IModelElement)this, PROP_PHONE_NUMBERS);
                        ListBindingImpl binding = this.resource().binding(PROP_PHONE_NUMBERS);
                        this.phoneNumbers.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_PHONE_NUMBERS);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PHONE_NUMBERS);
                    boolean notified = this.phoneNumbers.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_PHONE_NUMBERS);
                    }
                }
            } else if (property == PROP_PRIMARY_OCCUPATION) {
                if (this.primaryOccupation == null) {
                    if (force) {
                        this.primaryOccupation = new ModelElementHandle((IModelElement)this, PROP_PRIMARY_OCCUPATION);
                        this.primaryOccupation.init();
                    }
                } else {
                    this.primaryOccupation.refresh();
                }
            } else if (property == PROP_WEB_SITES) {
                if (this.webSites == null) {
                    if (force) {
                        this.webSites = new ModelElementList((IModelElement)this, PROP_WEB_SITES);
                        ListBindingImpl binding = this.resource().binding(PROP_WEB_SITES);
                        this.webSites.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_WEB_SITES);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_WEB_SITES);
                    boolean notified = this.webSites.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_WEB_SITES);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_ADDRESS) {
            return this.getAddress();
        }
        if (property == PROP_ASSISTANT) {
            return this.getAssistant();
        }
        if (property == PROP_CATEGORY) {
            return this.getCategory();
        }
        if (property == PROP_CONNECTIONS) {
            return this.getConnections();
        }
        if (property == PROP_E_MAIL) {
            return this.getEMail();
        }
        if (property == PROP_NAME) {
            return this.getName();
        }
        if (property == PROP_PHONE_NUMBERS) {
            return this.getPhoneNumbers();
        }
        if (property == PROP_PRIMARY_OCCUPATION) {
            return this.getPrimaryOccupation();
        }
        if (property == PROP_WEB_SITES) {
            return this.getWebSites();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_CATEGORY) {
            this.setCategory((String)value);
            return;
        }
        if (property == PROP_E_MAIL) {
            this.setEMail((String)value);
            return;
        }
        if (property == PROP_NAME) {
            this.setName((String)value);
            return;
        }
        super.write(property, value);
    }
}

