/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.tests.modeling.el.ITestModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestModelElement
extends ModelElement
implements ITestModelElement {
    private ModelElementHandle<ITestModelElement> fooBar;
    private Value<Integer> integerProp;
    private Value<String> stringProp;

    public TestModelElement(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public TestModelElement(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<ITestModelElement> getFooBar() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.fooBar == null) {
                this.refresh((ModelProperty)PROP_FOO_BAR, true);
            }
            return this.fooBar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getIntegerProp() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.integerProp == null) {
                this.refresh((ModelProperty)PROP_INTEGER_PROP, true);
            }
            return this.integerProp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIntegerProp(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_INTEGER_PROP.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_INTEGER_PROP, true);
            if (!TestModelElement.equal((String)this.integerProp.getText(false), (String)value)) {
                this.resource().binding(PROP_INTEGER_PROP).write(value);
                this.refresh((ModelProperty)PROP_INTEGER_PROP, false);
            }
        }
    }

    @Override
    public void setIntegerProp(Integer value) {
        this.setIntegerProp(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_INTEGER_PROP, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringProp() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.stringProp == null) {
                this.refresh((ModelProperty)PROP_STRING_PROP, true);
            }
            return this.stringProp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringProp(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_PROP.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_STRING_PROP, true);
            if (!TestModelElement.equal((String)this.stringProp.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_PROP).write(value);
                this.refresh((ModelProperty)PROP_STRING_PROP, false);
            }
        }
    }

    public boolean isPropertyEnabled(ModelProperty property) {
        if (property == PROP_FOO_BAR) {
            if (this.fooBar == null) {
                this.refresh((ModelProperty)PROP_FOO_BAR, true);
            }
            return this.fooBar.enabled();
        }
        return super.isPropertyEnabled(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_FOO_BAR) {
                if (this.fooBar == null) {
                    if (force) {
                        this.fooBar = new ModelElementHandle((IModelElement)this, PROP_FOO_BAR);
                        this.fooBar.init();
                    }
                } else {
                    this.fooBar.refresh();
                }
            } else if (property == PROP_INTEGER_PROP) {
                if (this.integerProp != null || force) {
                    Value<Integer> oldValue = this.integerProp;
                    String val = this.resource().binding(PROP_INTEGER_PROP).read();
                    this.integerProp = new Value((IModelElement)this, PROP_INTEGER_PROP, PROP_INTEGER_PROP.encodeKeywords(val));
                    this.integerProp.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_INTEGER_PROP);
                    if (oldValue != null) {
                        if (this.integerProp.equals(oldValue)) {
                            this.integerProp = oldValue;
                        }
                        if (this.integerProp != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_INTEGER_PROP);
                        }
                    }
                }
            } else if (property == PROP_STRING_PROP && (this.stringProp != null || force)) {
                Value<String> oldValue = this.stringProp;
                String val = this.resource().binding(PROP_STRING_PROP).read();
                this.stringProp = new Value((IModelElement)this, PROP_STRING_PROP, PROP_STRING_PROP.encodeKeywords(val));
                this.stringProp.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_STRING_PROP);
                if (oldValue != null) {
                    if (this.stringProp.equals(oldValue)) {
                        this.stringProp = oldValue;
                    }
                    if (this.stringProp != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_STRING_PROP);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_FOO_BAR) {
            return this.getFooBar();
        }
        if (property == PROP_INTEGER_PROP) {
            return this.getIntegerProp();
        }
        if (property == PROP_STRING_PROP) {
            return this.getStringProp();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_INTEGER_PROP) {
            if (!(value instanceof String)) {
                this.setIntegerProp((Integer)value);
            } else {
                this.setIntegerProp((String)value);
            }
            return;
        }
        if (property == PROP_STRING_PROP) {
            this.setStringProp((String)value);
            return;
        }
        super.write(property, value);
    }
}

