/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.IContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.ui.CorruptedResourceExceptionInterceptorImpl;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphireImageCache;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsPage;
import org.eclipse.sapphire.ui.internal.SapphireActionManager;
import org.eclipse.sapphire.ui.internal.SapphireEditorContentOutline;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireEditor
extends FormEditor
implements ISapphirePart {
    private static final String PREFS_LAST_ACTIVE_PAGE = "LastActivePage";
    private static final String PREFS_GLOBAL = "Global";
    private static final String PREFS_INSTANCE_BY_URI = "InstanceByUri";
    private static final String PREFS_INSTANCE_BY_EDITOR_INPUT_TYPE = "InstanceByEditorInputType";
    private final String pluginId;
    private IModelElement model;
    private IResourceChangeListener fileChangeListener;
    private final SapphireImageCache imageCache;
    private final Map<String, Object> pagesById;
    private SapphireEditorContentOutline outline;
    private final SapphireActionManager actionsManager;

    public SapphireEditor(String pluginId) {
        this.pluginId = pluginId;
        this.imageCache = new SapphireImageCache();
        this.pagesById = new HashMap<String, Object>();
        this.outline = null;
        this.actionsManager = new SapphireActionManager(this, this.getActionContexts());
    }

    @Override
    public ISapphirePartDef getDefinition() {
        return null;
    }

    @Override
    public final IModelElement getModelElement() {
        return this.model;
    }

    protected abstract IModelElement createModel();

    protected void adaptModel(IModelElement model) {
        CorruptedResourceExceptionInterceptorImpl interceptor = new CorruptedResourceExceptionInterceptorImpl(this.getEditorSite().getShell());
        this.model.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
    }

    public final Preferences getGlobalPreferences(boolean createIfNecessary) throws BackingStoreException {
        Preferences prefs = this.getPreferencesRoot(createIfNecessary);
        if (prefs != null && (prefs.nodeExists(PREFS_GLOBAL) || createIfNecessary)) {
            return prefs.node(PREFS_GLOBAL);
        }
        return null;
    }

    public final Preferences getInstancePreferences(boolean createIfNecessary) throws BackingStoreException {
        String level2;
        String level1;
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IURIEditorInput) {
            level1 = PREFS_INSTANCE_BY_URI;
            URI uri = ((IURIEditorInput)editorInput).getURI();
            level2 = uri != null ? ((IURIEditorInput)editorInput).getURI().toString() : "$#%**invalid**%#$";
        } else {
            level1 = PREFS_INSTANCE_BY_EDITOR_INPUT_TYPE;
            level2 = editorInput.getClass().getName();
        }
        Preferences prefs = this.getPreferencesRoot(createIfNecessary);
        if (prefs != null && (prefs.nodeExists(level1) || createIfNecessary) && ((prefs = prefs.node(level1)).nodeExists(level2) || createIfNecessary)) {
            return prefs.node(level2);
        }
        return null;
    }

    private final Preferences getPreferencesRoot(boolean createIfNecessary) throws BackingStoreException {
        String editorId;
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences prefs = scope.getNode(this.pluginId);
        if (prefs.nodeExists(editorId = this.getClass().getName()) || createIfNecessary) {
            return prefs.node(editorId);
        }
        return null;
    }

    public final String getLastActivePage() {
        String lastActivePage = this.getPageId(this.pages.get(0));
        try {
            Preferences prefs = this.getInstancePreferences(false);
            if (prefs != null) {
                lastActivePage = prefs.get(PREFS_LAST_ACTIVE_PAGE, lastActivePage);
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        return lastActivePage;
    }

    public final void setLastActivePage(String pageId) {
        try {
            Preferences prefs = this.getInstancePreferences(true);
            if (prefs != null) {
                prefs.put(PREFS_LAST_ACTIVE_PAGE, pageId);
                prefs.flush();
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            return ((FileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public final IProject getProject() {
        IFile ifile = this.getFile();
        return ifile == null ? null : ifile.getProject();
    }

    public final void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.doSetInput(input);
    }

    protected final void setInput(IEditorInput input) {
        this.doSetInput(input);
        super.setInput(input);
    }

    protected final void setInputWithNotify(IEditorInput input) {
        this.doSetInput(input);
        super.setInputWithNotify(input);
    }

    private void doSetInput(IEditorInput input) {
        this.setPartName(input.getName());
    }

    protected final void addPages() {
        IFile file = this.getFile();
        if (file.isAccessible()) {
            try {
                this.createSourcePages();
                this.model = this.createModel();
                this.adaptModel(this.model);
                this.createFormPages();
                this.createFileChangeListener();
            }
            catch (PartInitException e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            String lastActivePage = this.getLastActivePage();
            int page = 0;
            if (lastActivePage != null) {
                int count = this.getPageCount();
                int i = 0;
                while (i < count) {
                    String title = this.getPageText(i);
                    if (lastActivePage.equals(title)) {
                        page = i;
                        break;
                    }
                    ++i;
                }
            }
            this.setActivePage(page);
        } else {
            Composite page = new Composite(this.getContainer(), 0);
            page.setLayout((Layout)GridLayoutUtil.glayout(1));
            page.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
            SapphireFormText message = new SapphireFormText(page, 0);
            message.setLayoutData(GridLayoutUtil.gd());
            message.setBackground(this.getSite().getShell().getDisplay().getSystemColor(1));
            message.setText(Resources.resourceNotAccessible, false, false);
            this.addPage((Control)page);
            this.setPageText(0, Resources.errorPageTitle);
        }
    }

    protected abstract void createSourcePages() throws PartInitException;

    protected abstract void createFormPages() throws PartInitException;

    protected final void setPageId(Object page, String id) {
        this.pagesById.put(id, page);
    }

    public final Object getPage() {
        int pageIndex = this.getActivePage();
        if (pageIndex == -1) {
            return null;
        }
        return this.pages.get(pageIndex);
    }

    public final Object getPage(String id) {
        Object page = this.pagesById.get(id);
        if (page == null) {
            for (Object p : this.pages) {
                if (!(p instanceof SapphireEditorFormPage) || !((SapphireEditorFormPage)p).getId().equals(id)) continue;
                page = p;
                break;
            }
        }
        return page;
    }

    public final String getPageId(Object page) {
        String retId = null;
        for (String id : this.pagesById.keySet()) {
            Object p = this.pagesById.get(id);
            if (p != page) continue;
            retId = id;
            break;
        }
        return retId;
    }

    public final void showPage(String id) {
        Object page = this.getPage(id);
        if (page != null) {
            this.showPage(page);
            int index = this.pages.indexOf(page);
            this.setActivePage(index);
        }
    }

    public final void showPage(Object page) {
        int index = this.pages.indexOf(page);
        this.setActivePage(index);
    }

    protected void pageChange(int pageIndex) {
        Object page;
        super.pageChange(pageIndex);
        this.setLastActivePage(this.getPageText(pageIndex));
        if (this.outline != null && !this.outline.isDisposed()) {
            this.outline.refresh();
        }
        if ((page = this.pages.get(pageIndex)) instanceof SapphireEditorFormPage) {
            ((SapphireEditorFormPage)page).setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.model.resource().save();
        }
        catch (ResourceStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected final void createFileChangeListener() {
        this.fileChangeListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                SapphireEditor.this.handleFileChangedEvent(event);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fileChangeListener, 1);
    }

    protected final void handleFileChangedEvent(IResourceChangeEvent event) {
        IResourceDelta localDelta;
        IResourceDelta delta = event.getDelta();
        if (delta != null && (localDelta = delta.findMember(this.getFile().getFullPath())) != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (localDelta.getKind() == 2) {
                        SapphireEditor.this.getSite().getPage().closeEditor((IEditorPart)SapphireEditor.this, false);
                    }
                }
            });
        }
    }

    private final void disposeFileChangeListener() {
        if (this.fileChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fileChangeListener);
        }
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.imageCache.dispose();
        this.disposeFileChangeListener();
        this.actionsManager.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.outline == null || this.outline.isDisposed()) {
                this.outline = new SapphireEditorContentOutline(this);
            }
            return this.outline;
        }
        return super.getAdapter(adapter);
    }

    public final IContentOutlinePage getContentOutlineForActivePage() {
        int activePageIndex = this.getActivePage();
        Object page = this.pages.get(activePageIndex);
        return this.getContentOutline(page);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page instanceof MasterDetailsPage) {
            MasterDetailsPage mdpage = (MasterDetailsPage)page;
            return mdpage.getContentOutlinePage();
        }
        return null;
    }

    @Override
    public ISapphirePart getParentPart() {
        return null;
    }

    @Override
    public <T> T getNearestPart(Class<T> partType) {
        if (partType.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    @Override
    public Set<String> getActionContexts() {
        return Collections.emptySet();
    }

    @Override
    public final String getMainActionContext() {
        return this.actionsManager.getMainActionContext();
    }

    @Override
    public final SapphireActionGroup getActions() {
        return this.actionsManager.getActions();
    }

    @Override
    public final SapphireActionGroup getActions(String context) {
        return this.actionsManager.getActions(context);
    }

    @Override
    public final SapphireAction getAction(String id) {
        return this.actionsManager.getAction(id);
    }

    @Override
    public IStatus getValidationState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContext getDocumentationContext() {
        return null;
    }

    @Override
    public SapphireImageCache getImageCache() {
        return this.imageCache;
    }

    public void collectAllReferencedProperties(Set<ModelProperty> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(SapphirePartListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeListener(SapphirePartListener listener) {
        throw new UnsupportedOperationException();
    }

    private static final class Resources
    extends NLS {
        public static String resourceNotAccessible;
        public static String errorPageTitle;

        static {
            Resources.initializeMessages((String)SapphireEditor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

