/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ClassLoaderResourceResolver;
import org.eclipse.sapphire.modeling.ClassResolver;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.UrlResourceStore;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.def.ISapphireActionDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.def.ISapphireUiExtensionDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireExtensionSystem {
    private static List<ISapphireUiExtensionDef> extensions;
    private static List<ISapphireActionDef> actions;
    private static List<ISapphireActionHandlerDef> actionHandlers;
    private static List<ISapphireActionHandlerFactoryDef> actionHandlerFactories;

    public static synchronized List<ISapphireUiExtensionDef> getExtensions() {
        if (extensions == null) {
            ArrayList<ISapphireUiExtensionDef> list = new ArrayList<ISapphireUiExtensionDef>();
            for (final SapphireModelingExtensionSystem.ExtensionHandle handle : SapphireModelingExtensionSystem.getExtensionHandles()) {
                final ClassResolver classResolver = new ClassResolver(){

                    public Class<?> resolve(String name) {
                        try {
                            return handle.loadClass(name);
                        }
                        catch (SapphireModelingExtensionSystem.InvalidExtensionException invalidExtensionException) {
                            return null;
                        }
                    }
                };
                final ClassLoaderResourceResolver classLoaderResourceResolver = new ClassLoaderResourceResolver(){

                    public URL resolve(String name) {
                        return handle.resolveResource(name);
                    }
                };
                for (URL url : handle.findExtensionFiles()) {
                    try {
                        UrlResourceStore store = new UrlResourceStore(url){

                            public <A> A adapt(Class<A> adapterType) {
                                if (adapterType == ClassResolver.class) {
                                    return (A)classResolver;
                                }
                                if (adapterType == ClassLoaderResourceResolver.class) {
                                    return (A)classLoaderResourceResolver;
                                }
                                return (A)super.adapt(adapterType);
                            }
                        };
                        XmlResourceStore xmlResourceStore = new XmlResourceStore((ByteArrayResourceStore)store);
                        RootXmlResource resource = new RootXmlResource(xmlResourceStore);
                        ISapphireUiExtensionDef extension = (ISapphireUiExtensionDef)ISapphireUiExtensionDef.TYPE.instantiate((Resource)resource);
                        list.add(extension);
                    }
                    catch (ResourceStoreException e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
            }
            extensions = Collections.unmodifiableList(list);
        }
        return extensions;
    }

    public static synchronized List<ISapphireActionDef> getActions() {
        if (actions == null) {
            ArrayList<ISapphireActionDef> list = new ArrayList<ISapphireActionDef>();
            for (ISapphireUiExtensionDef extension : SapphireExtensionSystem.getExtensions()) {
                for (ISapphireActionDef def : extension.getActions()) {
                    list.add(def);
                }
            }
            actions = Collections.unmodifiableList(list);
        }
        return actions;
    }

    public static synchronized List<ISapphireActionHandlerDef> getActionHandlers() {
        if (actionHandlers == null) {
            ArrayList<ISapphireActionHandlerDef> list = new ArrayList<ISapphireActionHandlerDef>();
            for (ISapphireUiExtensionDef extension : SapphireExtensionSystem.getExtensions()) {
                for (ISapphireActionHandlerDef def : extension.getActionHandlers()) {
                    list.add(def);
                }
            }
            actionHandlers = Collections.unmodifiableList(list);
        }
        return actionHandlers;
    }

    public static synchronized List<ISapphireActionHandlerFactoryDef> getActionHandlerFactories() {
        if (actionHandlerFactories == null) {
            ArrayList<ISapphireActionHandlerFactoryDef> list = new ArrayList<ISapphireActionHandlerFactoryDef>();
            for (ISapphireUiExtensionDef extension : SapphireExtensionSystem.getExtensions()) {
                for (ISapphireActionHandlerFactoryDef def : extension.getActionHandlerFactories()) {
                    list.add(def);
                }
            }
            actionHandlerFactories = Collections.unmodifiableList(list);
        }
        return actionHandlerFactories;
    }
}

