/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.def.ISapphireActionImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireActionImage
extends ModelElement
implements ISapphireActionImage {
    private ReferenceValue<ImageDescriptor> image;

    public SapphireActionImage(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public SapphireActionImage(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<ImageDescriptor> getImage() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.image == null) {
                this.refresh((ModelProperty)PROP_IMAGE, true);
            }
            return this.image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_IMAGE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_IMAGE, true);
            if (!SapphireActionImage.equal((String)this.image.getText(false), (String)value)) {
                this.resource().binding(PROP_IMAGE).write(value);
                this.refresh((ModelProperty)PROP_IMAGE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_IMAGE && (this.image != null || force)) {
                ReferenceValue<ImageDescriptor> oldValue = this.image;
                String val = this.resource().binding(PROP_IMAGE).read();
                this.image = new ReferenceValue((IModelElement)this, PROP_IMAGE, PROP_IMAGE.encodeKeywords(val));
                this.image.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_IMAGE);
                if (oldValue != null) {
                    if (this.image.equals(oldValue)) {
                        this.image = oldValue;
                    }
                    if (this.image != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_IMAGE);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_IMAGE) {
            return this.getImage();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_IMAGE) {
            this.setImage((String)value);
            return;
        }
        super.write(property, value);
    }
}

