/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.editor.views.masterdetails;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireSection;
import org.eclipse.sapphire.ui.def.IEditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.def.ISapphirePartDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.editor.views.masterdetails.MasterDetailsContentTree;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.internal.TableWrapLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireMenuActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.sapphire.ui.util.internal.MutableReference;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterDetailsPage
extends SapphireEditorFormPage {
    static final String PREFS_CONTENT_TREE_STATE = "ContentTreeState";
    private static final String PREFS_VISIBLE = "Visible";
    private IEditorPageDef definition;
    private final MasterDetailsContentTree contentTree;
    private RootSection mainSection;
    private ContentOutline contentOutlinePage;

    public MasterDetailsPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation) {
        this(editor, rootModelElement, pageDefinitionLocation, null);
    }

    public MasterDetailsPage(SapphireEditor editor, IModelElement rootModelElement, IPath pageDefinitionLocation, String pageName) {
        super(editor, rootModelElement);
        String bundleId = pageDefinitionLocation.segment(0);
        String pageId = pageDefinitionLocation.lastSegment();
        String relPath = pageDefinitionLocation.removeFirstSegments(1).removeLastSegments(1).toPortableString();
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, relPath);
        for (IEditorPageDef pg : def.getEditorPageDefs()) {
            if (!pageId.equals(pg.getId().getText())) continue;
            this.definition = pg;
            break;
        }
        String partName = pageName;
        if (partName == null) {
            partName = this.definition.getPageName().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
        }
        this.setPartName(partName);
        this.contentTree = new MasterDetailsContentTree(this, this.definition, rootModelElement);
        SapphireAction outlineHideAction = this.getActions("Sapphire.EditorPage").getAction("Sapphire.Outline.Hide");
        SapphireActionHandler outlineHideActionHandler = new SapphireActionHandler(){

            protected Object run(SapphireRenderingContext context) {
                MasterDetailsPage.this.setDetailsMaximized(!MasterDetailsPage.this.isDetailsMaximized());
                return null;
            }
        };
        outlineHideActionHandler.init(outlineHideAction, null);
        outlineHideActionHandler.setChecked(this.isDetailsMaximized());
        outlineHideAction.addHandler(outlineHideActionHandler);
    }

    @Override
    public ISapphirePartDef getDefinition() {
        return this.definition;
    }

    @Override
    public String getId() {
        return this.getPartName();
    }

    @Override
    public IContext getDocumentationContext() {
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                SapphireHelpSystem.getContext(docdef);
            }
        }
        return null;
    }

    public MasterDetailsContentTree getContentTree() {
        return this.contentTree;
    }

    public void expandAllNodes() {
        for (MasterDetailsContentNode node : this.getContentTree().getRoot().getChildNodes()) {
            node.setExpanded(true, true);
        }
    }

    public void collapseAllNodes() {
        for (MasterDetailsContentNode node : this.getContentTree().getRoot().getChildNodes()) {
            node.setExpanded(false, true);
        }
    }

    public IDetailsPage getCurrentDetailsPage() {
        return this.mainSection.getCurrentDetailsSection();
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(managedForm.getForm().getForm());
        form.setText(this.definition.getPageHeaderText().getLocalizedText(CapitalizationType.TITLE_STYLE, false));
        this.mainSection = new RootSection();
        this.mainSection.createContent(managedForm);
        ISapphireDocumentation doc = (ISapphireDocumentation)this.definition.getDocumentation().element();
        if (doc != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = doc instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)doc : ((ISapphireDocumentationRef)doc).resolve();
            if (docdef != null) {
                SapphireHelpSystem.setHelp((Control)managedForm.getForm().getBody(), docdef);
            }
        }
        SapphireActionGroup actions = this.getActions("Sapphire.EditorPage");
        SapphireToolBarManagerActionPresentation actionPresentation = new SapphireToolBarManagerActionPresentation(this, this.getSite().getShell(), actions);
        actionPresentation.setToolBarManager(form.getToolBarManager());
        actionPresentation.render();
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = new ContentOutline();
        }
        return this.contentOutlinePage;
    }

    public boolean isDetailsMaximized() {
        try {
            boolean contentTreeVisible;
            Preferences prefs = this.getInstancePreferences(false);
            if (prefs != null && prefs.nodeExists(PREFS_CONTENT_TREE_STATE) && !(contentTreeVisible = (prefs = prefs.node(PREFS_CONTENT_TREE_STATE)).getBoolean(PREFS_VISIBLE, true))) {
                return true;
            }
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
        return false;
    }

    public void setDetailsMaximized(boolean maximized) {
        this.mainSection.setDetailsMaximized(maximized);
        try {
            Preferences prefs = this.getInstancePreferences(true).node(PREFS_CONTENT_TREE_STATE);
            prefs.putBoolean(PREFS_VISIBLE, !maximized);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
        }
    }

    @Override
    public Set<String> getActionContexts() {
        HashSet<String> contexts = new HashSet<String>();
        contexts.addAll(super.getActionContexts());
        contexts.add("Sapphire.EditorPage.Outline.Header");
        return contexts;
    }

    public void setFocus() {
        if (this.isDetailsMaximized()) {
            this.setFocusOnDetails();
        } else {
            this.setFocusOnContentOutline();
        }
    }

    public void setFocusOnContentOutline() {
        if (this.isDetailsMaximized()) {
            this.setDetailsMaximized(false);
        }
        this.mainSection.masterSection.tree.setFocus();
    }

    public void setFocusOnDetails() {
        Control control = this.findFirstFocusableControl(this.mainSection.detailsSectionControl);
        if (control != null) {
            control.setFocus();
        }
    }

    private Control findFirstFocusableControl(Control control) {
        if (control instanceof Text || control instanceof Combo || control instanceof Link || control instanceof List || control instanceof Table || control instanceof Tree) {
            return control;
        }
        if (control instanceof Text) {
            if ((((Text)control).getStyle() & 8) == 0) {
                return control;
            }
        } else if (control instanceof Button) {
            int style = control.getStyle();
            if ((style & 0x20) != 0 || (style & 0x10) != 0) {
                return control;
            }
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                Control res = this.findFirstFocusableControl(child);
                if (res != null) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    private FilteredTree createContentOutline(Composite parent, final MasterDetailsContentTree contentTree, boolean addBorders) {
        int treeStyle = (addBorders ? 2048 : 0) | 2;
        final ContentOutlineFilteredTree filteredTree = new ContentOutlineFilteredTree(parent, treeStyle, contentTree);
        final TreeViewer treeViewer = filteredTree.getViewer();
        ITreeContentProvider contentProvider = new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return contentTree.getRoot().getChildNodes().toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((MasterDetailsContentNode)parentElement).getChildNodes().toArray();
            }

            public Object getParent(Object element) {
                return ((MasterDetailsContentNode)element).getParentNode();
            }

            public boolean hasChildren(Object element) {
                return ((MasterDetailsContentNode)element).getChildNodes().size() > 0;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){
            private final Map<ImageDescriptor, Image> images = new HashMap<ImageDescriptor, Image>();

            public String getText(Object element) {
                return ((MasterDetailsContentNode)element).getLabel();
            }

            public Image getImage(Object element) {
                return this.getImage((MasterDetailsContentNode)element);
            }

            private Image getImage(MasterDetailsContentNode node) {
                ImageDescriptor imageDescriptor = node.getImageDescriptor();
                Image image = this.images.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.images.put(imageDescriptor, image);
                }
                return image;
            }

            public void dispose() {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
            }
        };
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setInput(new Object());
        final MutableReference<Boolean> ignoreSelectionChange = new MutableReference<Boolean>(false);
        final MutableReference<Boolean> ignoreExpandedStateChange = new MutableReference<Boolean>(false);
        final MasterDetailsContentTree.Listener contentTreeListener = new MasterDetailsContentTree.Listener(){

            @Override
            public void handleNodeUpdate(MasterDetailsContentNode node) {
                treeViewer.update((Object)node, null);
            }

            @Override
            public void handleNodeStructureChange(MasterDetailsContentNode node) {
                treeViewer.refresh((Object)node);
            }

            @Override
            public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                if (((Boolean)ignoreSelectionChange.get()).booleanValue()) {
                    return;
                }
                StructuredSelection sel = selection.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection(selection);
                if (!treeViewer.getSelection().equals(sel)) {
                    for (MasterDetailsContentNode node : selection) {
                        treeViewer.reveal((Object)node);
                    }
                    treeViewer.setSelection((ISelection)sel);
                }
            }

            @Override
            public void handleNodeExpandedStateChange(MasterDetailsContentNode node) {
                if (((Boolean)ignoreExpandedStateChange.get()).booleanValue()) {
                    return;
                }
                boolean expandedState = node.isExpanded();
                if (treeViewer.getExpandedState((Object)node) != expandedState) {
                    treeViewer.setExpandedState((Object)node, expandedState);
                }
            }

            @Override
            public void handleFilterChange(String newFilterText) {
                filteredTree.changeFilterText(newFilterText);
            }
        };
        contentTree.addListener(contentTreeListener);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ignoreSelectionChange.set(true);
                try {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ArrayList<MasterDetailsContentNode> nodes = new ArrayList<MasterDetailsContentNode>();
                    Iterator itr = selection.iterator();
                    while (itr.hasNext()) {
                        nodes.add((MasterDetailsContentNode)itr.next());
                    }
                    contentTree.setSelectedNodes(nodes);
                }
                finally {
                    ignoreSelectionChange.set(false);
                }
            }
        });
        treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                ignoreExpandedStateChange.set(true);
                try {
                    MasterDetailsContentNode node = (MasterDetailsContentNode)event.getElement();
                    node.setExpanded(true);
                }
                finally {
                    ignoreExpandedStateChange.set(false);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                ignoreExpandedStateChange.set(true);
                try {
                    MasterDetailsContentNode node = (MasterDetailsContentNode)event.getElement();
                    node.setExpanded(false);
                }
                finally {
                    ignoreExpandedStateChange.set(false);
                }
            }
        });
        Tree tree = treeViewer.getTree();
        final ContentOutlineActionSupport actionSupport = new ContentOutlineActionSupport(contentTree, tree);
        treeViewer.setExpandedElements(contentTree.getExpandedNodes().toArray());
        contentTreeListener.handleSelectionChange(contentTree.getSelectedNodes());
        filteredTree.changeFilterText(contentTree.getFilterText());
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                contentTree.removeListener(contentTreeListener);
                actionSupport.dispose();
            }
        });
        return filteredTree;
    }

    private static void updateExpandedState(MasterDetailsContentTree contentTree, Tree tree) {
        HashSet<MasterDetailsContentNode> expandedNodes = new HashSet<MasterDetailsContentNode>();
        MasterDetailsPage.gatherExpandedNodes(tree.getItems(), expandedNodes);
        contentTree.setExpandedNodes(expandedNodes);
    }

    private static void gatherExpandedNodes(TreeItem[] items, Set<MasterDetailsContentNode> result) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getExpanded()) {
                result.add((MasterDetailsContentNode)item.getData());
                MasterDetailsPage.gatherExpandedNodes(item.getItems(), result);
            }
            ++n2;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getContentTree().dispose();
        if (this.mainSection != null) {
            this.mainSection.dispose();
        }
    }

    private final class ContentOutline
    extends Page
    implements IContentOutlinePage {
        private Composite outerComposite = null;
        private FilteredTree filteredTree = null;
        private TreeViewer treeViewer = null;

        private ContentOutline() {
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            pageSite.setSelectionProvider((ISelectionProvider)this);
        }

        public void createControl(Composite parent) {
            this.outerComposite = new Composite(parent, 0);
            this.outerComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 5, 5));
            this.outerComposite.setBackground(Display.getCurrent().getSystemColor(1));
            this.filteredTree = MasterDetailsPage.this.createContentOutline(this.outerComposite, MasterDetailsPage.this.getContentTree(), false);
            this.filteredTree.setLayoutData((Object)GridLayoutUtil.gdfill());
            this.treeViewer = this.filteredTree.getViewer();
            SapphireActionGroup actions = MasterDetailsPage.this.getActions("Sapphire.EditorPage.Outline.Header");
            SapphireToolBarManagerActionPresentation actionsPresentation = new SapphireToolBarManagerActionPresentation(MasterDetailsPage.this, this.getSite().getShell(), actions);
            actionsPresentation.setToolBarManager(this.getSite().getActionBars().getToolBarManager());
            actionsPresentation.render();
        }

        public Control getControl() {
            return this.outerComposite;
        }

        public void setFocus() {
            this.treeViewer.getControl().setFocus();
        }

        public ISelection getSelection() {
            if (this.treeViewer == null) {
                return StructuredSelection.EMPTY;
            }
            return this.treeViewer.getSelection();
        }

        public void setSelection(ISelection selection) {
            if (this.treeViewer != null) {
                this.treeViewer.setSelection(selection);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ContentOutlineActionSupport {
        private final MasterDetailsContentTree contentTree;
        private final MasterDetailsContentTree.Listener contentOutlineListener;
        private final Tree tree;
        private final Menu menu;
        private SapphireActionPresentationManager actionPresentationManager;
        private SapphireActionGroup tempActions;

        private ContentOutlineActionSupport(MasterDetailsContentTree contentOutline, Tree tree) {
            this.contentTree = contentOutline;
            this.tree = tree;
            this.menu = new Menu((Control)tree);
            this.tree.setMenu(this.menu);
            this.contentOutlineListener = new MasterDetailsContentTree.Listener(){

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                    ContentOutlineActionSupport.this.handleSelectionChangedEvent(selection);
                }
            };
            this.contentTree.addListener(this.contentOutlineListener);
            this.handleSelectionChangedEvent(contentOutline.getSelectedNodes());
        }

        private void handleSelectionChangedEvent(List<MasterDetailsContentNode> selection) {
            SapphireActionGroup actions;
            MenuItem[] menuItemArray = this.menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
            if (this.tempActions != null) {
                this.tempActions.dispose();
                this.tempActions = null;
            }
            if (this.actionPresentationManager != null) {
                this.actionPresentationManager.dispose();
                this.actionPresentationManager = null;
            }
            if (selection.size() == 1) {
                MasterDetailsContentNode node = selection.get(0);
                actions = node.getActions("Sapphire.EditorPage.Outline.Node");
            } else {
                actions = this.tempActions = new SapphireActionGroup(MasterDetailsPage.this, "Sapphire.EditorPage.Outline");
            }
            this.actionPresentationManager = new SapphireActionPresentationManager(new SapphireRenderingContext((ISapphirePart)MasterDetailsPage.this, this.menu.getShell()), actions);
            SapphireMenuActionPresentation menuActionPresentation = new SapphireMenuActionPresentation(this.actionPresentationManager);
            menuActionPresentation.setMenu(this.menu);
            menuActionPresentation.render();
            SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(this.actionPresentationManager);
            keyboardActionPresentation.attach((Control)this.tree);
            keyboardActionPresentation.render();
        }

        public void dispose() {
            this.contentTree.removeListener(this.contentOutlineListener);
            if (this.tempActions != null) {
                this.tempActions.dispose();
                this.tempActions = null;
            }
            if (this.actionPresentationManager != null) {
                this.actionPresentationManager.dispose();
                this.actionPresentationManager = null;
            }
        }
    }

    private static final class ContentOutlineFilteredTree
    extends FilteredTree {
        private final MasterDetailsContentTree contentTree;
        private WorkbenchJob refreshJob;

        public ContentOutlineFilteredTree(Composite parent, int treeStyle, MasterDetailsContentTree contentTree) {
            super(parent, treeStyle, new PatternFilter(), true);
            this.contentTree = contentTree;
            this.setBackground(Display.getCurrent().getSystemColor(1));
        }

        protected WorkbenchJob doCreateRefreshJob() {
            final WorkbenchJob base = super.doCreateRefreshJob();
            this.refreshJob = new WorkbenchJob(base.getName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus st = base.runInUIThread((IProgressMonitor)new NullProgressMonitor());
                    if (st.getSeverity() == 8) {
                        return st;
                    }
                    ContentOutlineFilteredTree.this.contentTree.setFilterText(ContentOutlineFilteredTree.this.getFilterString());
                    MasterDetailsPage.updateExpandedState(ContentOutlineFilteredTree.this.contentTree, ContentOutlineFilteredTree.this.getViewer().getTree());
                    return Status.OK_STATUS;
                }
            };
            return this.refreshJob;
        }

        public void changeFilterText(String filterText) {
            String currentFilterText = this.getFilterString();
            if (currentFilterText != null && !currentFilterText.equals(filterText)) {
                this.setFilterText(filterText);
                this.textChanged();
            }
        }
    }

    private static class DetailsSection
    extends SapphireRenderingContext
    implements IDetailsPage {
        private MasterDetailsContentNode node;
        protected IManagedForm mform;
        protected FormToolkit toolkit;

        public DetailsSection() {
            super((ISapphirePart)null, (Shell)null);
        }

        public SapphirePart getPart() {
            return this.node;
        }

        public void initialize(IManagedForm form) {
            this.mform = form;
            this.toolkit = this.mform.getToolkit();
        }

        public final void createContents(Composite parent) {
            this.composite = parent;
            this.shell = this.composite.getShell();
            TableWrapLayout twl = TableWrapLayoutUtil.twlayout(1, 10, 10, 10, 10);
            twl.verticalSpacing = 20;
            parent.setLayout((Layout)twl);
            this.createSections();
        }

        public void commit(boolean onSave) {
        }

        public void dispose() {
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isStale() {
            return false;
        }

        public void refresh() {
        }

        public void setFocus() {
        }

        public boolean setFormInput(Object input) {
            return false;
        }

        public void adapt(Control control) {
            super.adapt(control);
            if (control instanceof Composite) {
                this.toolkit.adapt((Composite)control);
            } else if (control instanceof Label) {
                this.toolkit.adapt(control, false, false);
            } else {
                this.toolkit.adapt(control, true, true);
            }
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.node = ssel.size() == 1 ? (MasterDetailsContentNode)ssel.getFirstElement() : null;
            this.createSections();
        }

        protected void createSections() {
            Composite rootComposite = this.getComposite();
            Control[] controlArray = rootComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setVisible(false);
                control.dispose();
                ++n2;
            }
            if (this.node != null) {
                for (SapphireSection section : this.node.getSections()) {
                    if (!section.checkVisibleWhenCondition()) continue;
                    section.render(this);
                }
            }
            rootComposite.getParent().layout(true, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MasterSection
    extends Section {
        private IManagedForm managedForm;
        private SectionPart sectionPart;
        private TreeViewer treeViewer;
        private Tree tree;

        public MasterSection(IManagedForm managedForm, Composite parent) {
            super(parent, 256);
            FormToolkit toolkit = managedForm.getToolkit();
            FormColors colors = toolkit.getColors();
            this.setMenu(parent.getMenu());
            toolkit.adapt((Control)this, true, true);
            if (this.toggle != null) {
                this.toggle.setHoverDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE_HOVER"));
                this.toggle.setDecorationColor(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            }
            this.setFont(this.createBoldFont(colors.getDisplay(), this.getFont()));
            colors.initializeSectionToolBarColors();
            this.setTitleBarBackground(colors.getColor("org.eclipse.ui.forms.TB_BG"));
            this.setTitleBarBorderColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
            this.setTitleBarForeground(colors.getColor("org.eclipse.ui.forms.TB_TOGGLE"));
            this.marginWidth = 10;
            this.marginHeight = 10;
            this.setLayoutData(GridLayoutUtil.gdfill());
            this.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
            this.setText(MasterDetailsPage.this.definition.getOutlineHeaderText().getLocalizedText(CapitalizationType.TITLE_STYLE, false));
            Composite client = toolkit.createComposite((Composite)this);
            client.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
            this.managedForm = managedForm;
            MasterDetailsContentTree contentTree = MasterDetailsPage.this.getContentTree();
            FilteredTree filteredTree = MasterDetailsPage.this.createContentOutline(client, contentTree, true);
            this.treeViewer = filteredTree.getViewer();
            this.tree = this.treeViewer.getTree();
            this.sectionPart = new SectionPart((Section)this);
            this.managedForm.addPart((IFormPart)this.sectionPart);
            contentTree.addListener(new MasterDetailsContentTree.Listener(){

                @Override
                public void handleSelectionChange(List<MasterDetailsContentNode> selection) {
                    MasterSection.this.handleSelectionChangedEvent(selection);
                }
            });
            ToolBar toolbar = new ToolBar((Composite)this, 0x800100);
            this.setTextClient((Control)toolbar);
            SapphireActionGroup actions = MasterDetailsPage.this.getActions("Sapphire.EditorPage.Outline.Header");
            SapphireToolBarActionPresentation actionsPresentation = new SapphireToolBarActionPresentation(MasterDetailsPage.this, MasterDetailsPage.this.getSite().getShell(), actions);
            actionsPresentation.setToolBar(toolbar);
            actionsPresentation.render();
            toolkit.paintBordersFor((Composite)this);
            this.setClient((Control)client);
        }

        private Font createBoldFont(Display display, Font regularFont) {
            FontData[] fontDatas = regularFont.getFontData();
            int i = 0;
            while (i < fontDatas.length) {
                fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
                ++i;
            }
            return new Font((Device)display, fontDatas);
        }

        private void handleSelectionChangedEvent(List<MasterDetailsContentNode> selection) {
            StructuredSelection sel = selection.isEmpty() ? StructuredSelection.EMPTY : new StructuredSelection((Object)selection.get(0));
            this.managedForm.fireSelectionChanged((IFormPart)this.sectionPart, (ISelection)sel);
        }
    }

    private final class RootSection
    extends MasterDetailsBlock {
        private MasterSection masterSection;
        private List<IDetailsPage> detailsSections = new ArrayList<IDetailsPage>();
        private Control detailsSectionControl = null;

        public void createContent(IManagedForm managedForm) {
            super.createContent(managedForm);
            this.sashForm.setWeights(new int[]{3, 7});
            try {
                Field field = this.detailsPart.getClass().getDeclaredField("pageBook");
                field.setAccessible(true);
                this.detailsSectionControl = (Control)field.get(this.detailsPart);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
            this.masterSection.handleSelectionChangedEvent(MasterDetailsPage.this.getContentTree().getSelectedNodes());
            this.setDetailsMaximized(MasterDetailsPage.this.isDetailsMaximized());
        }

        protected void createMasterPart(IManagedForm managedForm, Composite parent) {
            this.masterSection = new MasterSection(managedForm, parent);
            SectionPart spart = new SectionPart((Section)this.masterSection);
            managedForm.addPart((IFormPart)spart);
        }

        protected void registerPages(DetailsPart detailsPart) {
            DetailsSection detailsPage = new DetailsSection();
            detailsPart.registerPage(MasterDetailsContentNode.class, (IDetailsPage)detailsPage);
            this.detailsSections.add(detailsPage);
        }

        protected void applyLayoutData(SashForm sashForm) {
            sashForm.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhhint(GridLayoutUtil.gdfill(), 200), 400));
        }

        public IDetailsPage getCurrentDetailsSection() {
            return this.detailsPart.getCurrentPage();
        }

        public void setDetailsMaximized(boolean maximized) {
            this.sashForm.setMaximizedControl(maximized ? this.detailsSectionControl : null);
        }

        public void dispose() {
            if (this.masterSection != null) {
                this.masterSection.dispose();
            }
            for (IDetailsPage section : this.detailsSections) {
                section.dispose();
            }
        }

        protected void createToolBarActions(IManagedForm managedForm) {
        }
    }
}

