/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePropertyEditor;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDecorator;
import org.eclipse.sapphire.ui.internal.EnhancedComposite;
import org.eclipse.sapphire.ui.internal.binding.AbstractBinding;
import org.eclipse.sapphire.ui.renderers.swt.CompactListTextAssistDecorator;
import org.eclipse.sapphire.ui.renderers.swt.CompactTextBinding;
import org.eclipse.sapphire.ui.renderers.swt.ListPropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRenderer;
import org.eclipse.sapphire.ui.renderers.swt.PropertyEditorRendererFactory;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarActionPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public class CompactListPropertyEditorRenderer
extends ListPropertyEditorRenderer {
    public static final String DATA_SELECTION_PROVIDER = "selection.provider";
    private Runnable refreshOperation;
    ValueProperty memberProperty;
    private Composite innerComposite;
    private Composite textComposite;
    private List<CompactTextBinding> textBindings = new ArrayList<CompactTextBinding>();
    private FormText addText;
    private HyperlinkAdapter addTextHyperlinkAdapter;

    public CompactListPropertyEditorRenderer(SapphireRenderingContext context, SapphirePropertyEditor part) {
        super(context, part);
    }

    protected void createContents(Composite parent) {
        this.createContents(parent, false, false);
    }

    protected Control createContents(Composite parent, boolean suppressLabel, boolean ignoreLeftMarginHint) {
        Label label;
        ModelProperty prop;
        SapphirePropertyEditor part = this.getPart();
        part.getModelElement();
        ListProperty property = (ListProperty)part.getProperty();
        boolean isReadOnly = property.isReadOnly() || part.getRenderingHint("read.only", false);
        boolean showLabelAbove = part.getRenderingHint("show.label.above", false);
        boolean showLabelInline = part.getRenderingHint("show.label", suppressLabel ? false : !showLabelAbove);
        int leftMargin = ignoreLeftMarginHint ? 0 : part.getLeftMarginHint();
        List allMemberProperties = property.getType().getProperties();
        if (allMemberProperties.size() == 1) {
            prop = (ModelProperty)allMemberProperties.get(0);
            if (!(prop instanceof ValueProperty)) {
                throw new IllegalStateException();
            }
        } else {
            throw new IllegalStateException();
        }
        this.memberProperty = (ValueProperty)prop;
        if (showLabelInline || showLabelAbove) {
            String labelText = String.valueOf(property.getLabel(false, CapitalizationType.FIRST_WORD_ONLY, true)) + ":";
            label = new Label(parent, 0);
            label.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128), showLabelAbove ? 2 : 1), leftMargin + 9));
            label.setText(labelText);
            this.context.adapt((Control)label);
        } else {
            label = null;
        }
        EnhancedComposite outerComposite = new EnhancedComposite(parent, 0);
        outerComposite.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), showLabelInline ? 1 : 2), showLabelInline ? 0 : leftMargin));
        outerComposite.setLayout((Layout)GridLayoutUtil.glayout(isReadOnly ? 1 : 2, 0, 0, 0, 0));
        this.context.adapt((Control)outerComposite);
        this.innerComposite = new Composite((Composite)outerComposite, 0);
        this.innerComposite.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.innerComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(2, 0, 0), 2));
        this.addControls(1);
        ArrayList<Label> relatedControls = new ArrayList<Label>();
        if (label != null) {
            relatedControls.add(label);
        }
        this.refreshOperation = new Runnable(){
            boolean running = false;

            public void run() {
                if (CompactListPropertyEditorRenderer.this.innerComposite.isDisposed()) {
                    return;
                }
                if (this.running) {
                    return;
                }
                this.running = true;
                try {
                    CompactListPropertyEditorRenderer.this.refreshControls();
                }
                finally {
                    this.running = false;
                }
            }
        };
        this.binding = new AbstractBinding(this.getPart(), this.context, (Control)this.innerComposite){

            protected void doUpdateModel() {
            }

            protected void doUpdateTarget() {
                CompactListPropertyEditorRenderer.this.refreshOperation.run();
            }
        };
        this.addControl((Control)this.innerComposite);
        return this.innerComposite;
    }

    private void addControls(int count) {
        if (this.addText != null && this.addTextHyperlinkAdapter != null) {
            this.addText.removeHyperlinkListener((IHyperlinkListener)this.addTextHyperlinkAdapter);
        }
        int i = 0;
        while (i < this.textBindings.size()) {
            this.textBindings.get(i).removeListener();
            ++i;
        }
        Control[] controlArray = this.innerComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.textBindings.clear();
        this.textComposite = new Composite(this.innerComposite, 0);
        this.textComposite.setLayoutData((Object)GridLayoutUtil.gdhspan(GridLayoutUtil.gdfill(), 2));
        this.textComposite.setLayout((Layout)GridLayoutUtil.glspacing(GridLayoutUtil.glayout(3, 0, 0), 2, 5));
        i = 0;
        while (i < count) {
            CompactListTextAssistDecorator decorator = this.addDecorator();
            Text text = new Text(this.textComposite, 2048);
            text.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 150));
            CompactTextBinding binding = new CompactTextBinding(this, text);
            binding.setDecorator(decorator);
            decorator.setBinding(binding);
            this.textBindings.add(binding);
            this.addToolbar(binding);
            ++i;
        }
        this.addText = new FormText(this.innerComposite, 0);
        this.addText.setLayoutData((Object)GridLayoutUtil.gdhindent(GridLayoutUtil.gdvalign(GridLayoutUtil.gdhfill(), 0x1000000), 10));
        this.context.adapt((Control)this.addText);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\"><a href=\"action\" nowrap=\"true\">");
        buf.append("Add ");
        buf.append(this.memberProperty.getLabel(false, CapitalizationType.NO_CAPS, false));
        buf.append("</a></p></form>");
        this.addText.setText(buf.toString(), true, false);
        if (this.addTextHyperlinkAdapter == null) {
            this.addTextHyperlinkAdapter = new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent event) {
                    CompactListPropertyEditorRenderer.this.addActivated();
                    CompactListPropertyEditorRenderer.this.refreshDeleteActions();
                }
            };
        }
        this.addText.addHyperlinkListener((IHyperlinkListener)this.addTextHyperlinkAdapter);
    }

    private void addToolbar(CompactTextBinding binding) {
        SapphireActionGroup actions = new SapphireActionGroup(this.getPart(), this.getPart().getActionContext());
        final SapphireAction deleteAction = actions.getAction("Sapphire.Delete");
        final DeleteActionHandler deleteActionHandler = new DeleteActionHandler(binding);
        deleteActionHandler.init(deleteAction, null);
        deleteAction.addHandler(deleteActionHandler);
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(this.context, actions);
        SapphireToolBarActionPresentation toolBarActionsPresentation = new SapphireToolBarActionPresentation(actionPresentationManager);
        ToolBar toolbar = new ToolBar(this.textComposite, 0x800100);
        toolbar.setLayoutData((Object)GridLayoutUtil.gdvfill());
        toolBarActionsPresentation.setToolBar(toolbar);
        toolBarActionsPresentation.render();
        this.context.adapt((Control)toolbar);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                deleteAction.removeHandler(deleteActionHandler);
            }
        });
        binding.setToolbar(toolbar);
        binding.setDeleteActionHandler(deleteActionHandler);
    }

    private CompactListTextAssistDecorator addDecorator() {
        CompactListTextAssistDecorator decorator = new CompactListTextAssistDecorator(this.getPart(), (ModelProperty)this.memberProperty, this.context, this.textComposite);
        decorator.getControl().setLayoutData((Object)GridLayoutUtil.gdvalign(GridLayoutUtil.gd(), 128));
        return decorator;
    }

    private void addActivated() {
        CompactListTextAssistDecorator decorator = this.addDecorator();
        Text text = new Text(this.textComposite, 2048);
        text.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gdhfill(), 150));
        CompactTextBinding binding = new CompactTextBinding(this, text);
        binding.setDecorator(decorator);
        decorator.setBinding(binding);
        this.textBindings.add(binding);
        this.addToolbar(binding);
        this.context.layout();
        text.setFocus();
    }

    private void refreshControls() {
        this.refreshDeleteActions();
        if (!this.needsRefresh()) {
            return;
        }
        ModelElementList<IModelElement> list = this.getList();
        if (list.size() != this.textBindings.size()) {
            this.addControls(Math.max(1, list.size()));
            this.context.layout();
        }
        int i = 0;
        while (i < list.size()) {
            IModelElement elem = list.get(i);
            String value = elem.read(this.memberProperty).getText();
            value = value == null ? "" : value;
            Text text = this.textBindings.get(i).getText();
            this.textBindings.get(i).setModelElement(elem);
            if (!CompactListPropertyEditorRenderer.equals(value, text.getText())) {
                text.setText(value);
            }
            ++i;
        }
        if (list.size() == 0) {
            this.textBindings.get(0).setModelElement(null);
            this.textBindings.get(0).getText().setText("");
        }
    }

    private void refreshDeleteActions() {
        int size = this.textBindings.size();
        int i = 0;
        while (i < size) {
            CompactTextBinding binding = this.textBindings.get(i);
            if (i == 0 && size == 1) {
                binding.getDeleteActionHandler().refreshEnablement();
            } else {
                binding.getDeleteActionHandler().setEnabled(true);
            }
            binding.getDecorator().refresh();
            ++i;
        }
    }

    private boolean needsRefresh() {
        for (CompactTextBinding binding : this.textBindings) {
            if (!binding.isModifying()) continue;
            return false;
        }
        ModelElementList<IModelElement> list = this.getList();
        if (list.size() > this.textBindings.size()) {
            return true;
        }
        int index = 0;
        for (IModelElement elem : list) {
            if ((index = this.findElement(index, elem)) != -1) continue;
            return true;
        }
        int i = index;
        while (i < this.textBindings.size()) {
            if (this.textBindings.get(i).getModelElement() != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int findElement(int startIndex, IModelElement elem) {
        int i = startIndex;
        while (i < this.textBindings.size()) {
            IModelElement elem2 = this.textBindings.get(i).getModelElement();
            Text text = this.textBindings.get(i).getText();
            String value = elem != null ? elem.read(this.memberProperty).getText() : null;
            String string = value = value == null ? "" : value;
            if (CompactListPropertyEditorRenderer.equals(elem, elem2) && CompactListPropertyEditorRenderer.equals(value, text.getText())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void deleteBinding(CompactTextBinding binding) {
        IModelElement elem = binding.getModelElement();
        Text text = binding.getText();
        ToolBar toolbar = binding.getToolbar();
        CompactListTextAssistDecorator decorator = binding.getDecorator();
        binding.setModifying(true);
        if (elem != null) {
            this.getList().remove((Object)elem);
        }
        binding.setModifying(false);
        if (this.textBindings.size() > 1) {
            binding.removeListener();
            this.textBindings.remove(binding);
            text.dispose();
            toolbar.dispose();
            Label control = decorator.getControl();
            decorator.removeEditorControl((Control)control);
            control.dispose();
            this.context.layout();
        } else {
            binding.setModelElement(null);
            text.setText("");
        }
        this.refreshDeleteActions();
    }

    private static final boolean equals(Object o1, Object o2) {
        boolean objectsAreEqual = false;
        if (o1 == o2) {
            objectsAreEqual = true;
        } else if (o1 != null && o2 != null) {
            objectsAreEqual = o1.equals(o2);
        }
        return objectsAreEqual;
    }

    public final PropertyEditorAssistDecorator getDecorator() {
        return this.decorator;
    }

    public final void setDecorator(PropertyEditorAssistDecorator decorator) {
        this.decorator = decorator;
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.refreshOperation.run();
    }

    protected void handleListElementChangedEvent(ModelPropertyChangeEvent event) {
        super.handleListElementChangedEvent(event);
        this.refreshOperation.run();
    }

    protected void handleFocusReceivedEvent() {
        this.textBindings.get(0).getText().setFocus();
    }

    public final class DeleteActionHandler
    extends SapphireActionHandler {
        CompactTextBinding binding;

        public DeleteActionHandler(CompactTextBinding binding) {
            this.binding = binding;
        }

        protected Object run(SapphireRenderingContext context) {
            CompactListPropertyEditorRenderer.this.deleteBinding(this.binding);
            return null;
        }

        public final void refreshEnablement() {
            this.setEnabled(this.binding.getModelElement() != null);
        }
    }

    public static final class Factory
    extends PropertyEditorRendererFactory {
        public boolean isApplicableTo(SapphirePropertyEditor propertyEditorDefinition) {
            return propertyEditorDefinition.getProperty() instanceof ListProperty;
        }

        public PropertyEditorRenderer create(SapphireRenderingContext context, SapphirePropertyEditor part) {
            return new CompactListPropertyEditorRenderer(context, part);
        }
    }
}

