/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.modeling.util.internal.MiscUtil;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.SapphireActionType;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireHotSpotsActionPresentation;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public final class SapphireToolBarManagerActionPresentation
extends SapphireHotSpotsActionPresentation {
    private IToolBarManager toolbar;

    public SapphireToolBarManagerActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    public SapphireToolBarManagerActionPresentation(ISapphirePart part, Shell shell, SapphireActionGroup actions) {
        this(new SapphireActionPresentationManager(new SapphireRenderingContext(part, shell), actions));
    }

    public IToolBarManager getToolBarManager() {
        return this.toolbar;
    }

    public void setToolBarManager(IToolBarManager toolbar) {
        this.toolbar = toolbar;
    }

    public void render() {
        SapphireToolBarManagerActionPresentation.setCursor(this.toolbar, null);
        final SapphireRenderingContext context = this.getManager().getContext();
        boolean first = true;
        String lastGroup = null;
        for (final SapphireAction action : this.getActions()) {
            Action a;
            String group = action.getGroup();
            if (!first && !MiscUtil.equal(lastGroup, (Object)group)) {
                this.toolbar.add((IContributionItem)new Separator());
            }
            first = false;
            lastGroup = group;
            final List<SapphireActionHandler> handlers = action.getActiveHandlers();
            if (action.getType() == SapphireActionType.PUSH) {
                a = new Action(null, 1){

                    public void run() {
                        if (handlers.size() == 1) {
                            ((SapphireActionHandler)handlers.get(0)).execute(context);
                        } else {
                            SapphireToolBarManagerActionPresentation.this.displayActionHandlerChoice(action);
                        }
                    }
                };
                this.registerHotSpot(action, new JFaceActionHotSpot(a));
            } else if (action.getType() == SapphireActionType.TOGGLE) {
                a = new Action(null, 2){

                    public void run() {
                        ((SapphireActionHandler)handlers.get(0)).execute(context);
                    }
                };
            } else {
                throw new IllegalStateException();
            }
            a.setImageDescriptor(action.getImage(16));
            a.setToolTipText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
            this.toolbar.add((IAction)a);
            final Runnable updateActionEnablementStateOp = new Runnable(){

                public void run() {
                    a.setEnabled(action.isEnabled());
                }
            };
            final Runnable updateActionCheckedStateOp = new Runnable(){

                public void run() {
                    a.setChecked(action.isChecked());
                }
            };
            action.addListener(new SapphireActionSystemPart.Listener(){

                public void handleEvent(SapphireActionSystemPart.Event event) {
                    String type = event.getType();
                    if (type.equals("enablement")) {
                        updateActionEnablementStateOp.run();
                    } else if (type.equals("checked")) {
                        updateActionCheckedStateOp.run();
                    }
                }
            });
            updateActionEnablementStateOp.run();
            updateActionCheckedStateOp.run();
        }
        this.toolbar.update(true);
    }

    private static void setCursor(IToolBarManager toolBarManager, Cursor cursor) {
        if (toolBarManager instanceof ToolBarManager) {
            ((ToolBarManager)toolBarManager).getControl().setCursor(null);
        } else if (toolBarManager instanceof SubToolBarManager) {
            SapphireToolBarManagerActionPresentation.setCursor((IToolBarManager)((SubToolBarManager)toolBarManager).getParent(), cursor);
        }
    }

    private final class JFaceActionHotSpot
    extends SapphireHotSpotsActionPresentation.HotSpot {
        private final Action action;

        public JFaceActionHotSpot(Action item) {
            this.action = item;
        }

        public Rectangle getBounds() {
            ToolItem actionToolItem = null;
            ToolItem[] toolItemArray = this.getToolBar(SapphireToolBarManagerActionPresentation.this.getToolBarManager()).getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem toolItem = toolItemArray[n2];
                Object data = toolItem.getData();
                if (data instanceof IContributionItem && this.getJFaceAction((IContributionItem)data) == this.action) {
                    actionToolItem = toolItem;
                    break;
                }
                ++n2;
            }
            return this.toDisplay((Control)actionToolItem.getParent(), actionToolItem.getBounds());
        }

        private IAction getJFaceAction(IContributionItem item) {
            if (item instanceof ActionContributionItem) {
                return ((ActionContributionItem)item).getAction();
            }
            if (item instanceof SubContributionItem) {
                return this.getJFaceAction(((SubContributionItem)item).getInnerItem());
            }
            return null;
        }

        private ToolBar getToolBar(IToolBarManager manager) {
            if (manager instanceof ToolBarManager) {
                return ((ToolBarManager)manager).getControl();
            }
            if (manager instanceof SubToolBarManager) {
                return this.getToolBar((IToolBarManager)((SubToolBarManager)manager).getParent());
            }
            throw new IllegalStateException(manager.getClass().getName());
        }
    }
}

