/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ValidFileExtensions;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public final class AbsoluteFilePathBrowseActionHandler
extends SapphireBrowseActionHandler {
    public static final String ID = "Sapphire.Browse.File.Absolute";
    public static final String PARAM_EXTENSIONS = "extensions";
    public List<String> extensions;

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        block5: {
            ValueProperty property;
            block4: {
                super.init(action, def);
                this.setId(ID);
                this.setLabel(Resources.label);
                this.addImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
                property = this.getProperty();
                this.extensions = Collections.emptyList();
                String paramExtensions = def.getParam(PARAM_EXTENSIONS);
                if (paramExtensions == null) break block4;
                this.extensions = new ArrayList<String>();
                String[] stringArray = paramExtensions.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if ((extension = extension.trim()).length() > 0) {
                        this.extensions.add(extension);
                    }
                    ++n2;
                }
                break block5;
            }
            ValidFileExtensions validFileExtensionsAnnotation = (ValidFileExtensions)property.getAnnotation(ValidFileExtensions.class);
            if (validFileExtensionsAnnotation == null) break block5;
            this.extensions = new ArrayList<String>();
            String[] stringArray = validFileExtensionsAnnotation.value();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String extension = stringArray[n3];
                if ((extension = extension.trim()).length() > 0) {
                    this.extensions.add(extension);
                }
                ++n3;
            }
        }
    }

    protected String browse(SapphireRenderingContext context) {
        ValueProperty property = this.getProperty();
        FileDialog dialog = new FileDialog(context.getShell());
        dialog.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        Value value = this.getModelElement().read(property);
        IPath path = (IPath)value.getContent();
        if (path != null && path.segmentCount() > 1) {
            dialog.setFilterPath(path.removeLastSegments(1).toOSString());
            dialog.setFileName(path.lastSegment());
        }
        if (!this.extensions.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String extension : this.extensions) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append("*.");
                buf.append(extension);
            }
            dialog.setFilterExtensions(new String[]{buf.toString()});
        }
        return dialog.open();
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)AbsoluteFilePathBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

