/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.internal.SapphireModelingFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PossibleValuesService
extends ModelPropertyService {
    private final Set<Listener> listeners = new CopyOnWriteArraySet<Listener>();

    public final SortedSet<String> getPossibleValues() {
        TreeSet<String> values = new TreeSet<String>();
        this.fillPossibleValues(values);
        return values;
    }

    protected abstract void fillPossibleValues(SortedSet<String> var1);

    public String getInvalidValueMessage(String invalidValue) {
        return NLS.bind((String)Resources.defaultInvalidValueMessage, (Object)invalidValue, (Object)this.property().getLabel(true, CapitalizationType.NO_CAPS, false));
    }

    public int getInvalidValueSeverity(String invalidValue) {
        return 4;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public final void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.remove(listener);
    }

    protected final void notifyListeners(PossibleValuesChangedEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        for (Listener listener : this.listeners) {
            try {
                listener.handlePossibleValuesChangedEvent(event);
            }
            catch (Exception e) {
                SapphireModelingFrameworkPlugin.log(e);
            }
        }
    }

    public static abstract class Listener {
        public abstract void handlePossibleValuesChangedEvent(PossibleValuesChangedEvent var1);
    }

    public static class PossibleValuesChangedEvent {
    }

    private static final class Resources
    extends NLS {
        public static String defaultInvalidValueMessage;

        static {
            Resources.initializeMessages((String)PossibleValuesService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

