/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlGroupContentModel;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlChoiceGroup
extends XmlGroupContentModel {
    public XmlChoiceGroup(XmlDocumentSchema schema, int minOccur, int maxOccur, List<XmlContentModel> list) {
        super(schema, minOccur, maxOccur, list);
    }

    public XmlChoiceGroup(XmlDocumentSchema schema, int minOccur, int maxOccur, XmlContentModel ... list) {
        super(schema, minOccur, maxOccur, list);
    }

    @Override
    protected XmlContentModel.InsertionPosition findInsertionPosition(NodeList nodeList, int nodeListLength, QName qname, XmlContentModel.Position position) {
        XmlContentModel.InsertionPosition result = new XmlContentModel.InsertionPosition();
        if (position.listIndex < nodeListLength) {
            int i = 0;
            while (true) {
                if (position.listIndex < nodeListLength && nodeList.item(position.listIndex).getNodeType() != 1) {
                    ++position.listIndex;
                    continue;
                }
                int startingPosition = position.listIndex;
                int maxProgress = 0;
                XmlContentModel.InsertionPosition maxProgressResult = new XmlContentModel.InsertionPosition();
                for (XmlContentModel entry : this.getNestedContent()) {
                    position.listIndex = startingPosition;
                    XmlContentModel.InsertionPosition branchResult = entry.findInsertionPosition(nodeList, nodeListLength, qname, position);
                    int branchProgress = position.listIndex - startingPosition;
                    if (branchProgress <= maxProgress && (maxProgress != 0 || branchResult.grade <= 0)) continue;
                    maxProgress = branchProgress;
                    maxProgressResult = branchResult;
                }
                position.listIndex = startingPosition + maxProgress;
                if (position.listIndex == startingPosition) {
                    maxProgressResult.grade = this.maxOccur != -1 && ++i > this.maxOccur ? 1 : (i <= this.minOccur ? 4 : 2);
                    result.merge(maxProgressResult);
                    break;
                }
                result.merge(maxProgressResult);
                ++i;
            }
        }
        return result;
    }

    @Override
    protected void toString(StringBuilder buf, String indent) {
        buf.append(indent);
        buf.append("choice [");
        buf.append(this.minOccur);
        buf.append(':');
        buf.append(this.maxOccur);
        buf.append("]\n");
        buf.append(indent);
        buf.append("{\n");
        String nextLevelIndent = String.valueOf(indent) + "    ";
        for (XmlContentModel childContentModel : this.getNestedContent()) {
            childContentModel.toString(buf, nextLevelIndent);
            buf.append('\n');
        }
        buf.append(indent);
        buf.append('}');
    }
}

