/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.extensibility;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.LongString;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.extensibility.internal.ClassReferenceService;
import org.eclipse.sapphire.modeling.java.JavaTypeConstraints;
import org.eclipse.sapphire.modeling.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.localization.Localizable;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlValueBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Label(standard="model element service")
@GenerateImpl
public interface IModelElementServiceDef
extends IModelElement {
    public static final ModelElementType TYPE = new ModelElementType(IModelElementServiceDef.class);
    @LongString
    @Label(standard="description")
    @Localizable
    @XmlValueBinding(path="description", collapseWhitespace=true)
    @Documentation(content="Provides information about the model element service. The description should be in the form of properly capitalized and punctuated sentences.")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, "Description");
    @Reference(target=Class.class, service=ClassReferenceService.class)
    @Label(standard="service type class")
    @NonNullValue
    @JavaTypeConstraints(kind={JavaTypeKind.CLASS, JavaTypeKind.ABSTRACT_CLASS, JavaTypeKind.INTERFACE}, type={"org.eclipse.sapphire.modeling.ModelElementService"})
    @MustExist
    @XmlBinding(path="type")
    @Documentation(content="The type of service that the factory can create. Must extend ModelElementService.")
    public static final ValueProperty PROP_TYPE_CLASS = new ValueProperty(TYPE, "TypeClass");
    @Reference(target=Class.class, service=ClassReferenceService.class)
    @Label(standard="service factory class")
    @NonNullValue
    @JavaTypeConstraints(kind={JavaTypeKind.CLASS}, type={"org.eclipse.sapphire.modeling.ModelElementServiceFactory"})
    @MustExist
    @XmlBinding(path="factory")
    @Documentation(content="The factory that can create a service of the specified type. Must extend ModelElementServiceFactory.")
    public static final ValueProperty PROP_FACTORY_CLASS = new ValueProperty(TYPE, "FactoryClass");

    public Value<String> getDescription();

    public void setDescription(String var1);

    public ReferenceValue<Class<?>> getTypeClass();

    public void setTypeClass(String var1);

    public ReferenceValue<Class<?>> getFactoryClass();

    public void setFactoryClass(String var1);
}

