/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.extensibility.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.extensibility.IFunctionDef;
import org.eclipse.sapphire.modeling.extensibility.IModelElementServiceDef;
import org.eclipse.sapphire.modeling.extensibility.IModelPropertyServiceDef;
import org.eclipse.sapphire.modeling.extensibility.ISapphireModelingExtensionDef;
import org.eclipse.sapphire.modeling.extensibility.IValueSerializationServiceDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireModelingExtensionDef
extends ModelElement
implements ISapphireModelingExtensionDef {
    private ModelElementList<IFunctionDef> functions;
    private ModelElementList<IModelElementServiceDef> modelElementServices;
    private ModelElementList<IModelPropertyServiceDef> modelPropertyServices;
    private ModelElementList<IValueSerializationServiceDef> valueSerializationServices;

    public SapphireModelingExtensionDef(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public SapphireModelingExtensionDef(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IFunctionDef> getFunctions() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.functions == null) {
                this.refresh((ModelProperty)PROP_FUNCTIONS, true);
            }
            return this.functions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IModelElementServiceDef> getModelElementServices() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.modelElementServices == null) {
                this.refresh((ModelProperty)PROP_MODEL_ELEMENT_SERVICES, true);
            }
            return this.modelElementServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IModelPropertyServiceDef> getModelPropertyServices() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.modelPropertyServices == null) {
                this.refresh((ModelProperty)PROP_MODEL_PROPERTY_SERVICES, true);
            }
            return this.modelPropertyServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IValueSerializationServiceDef> getValueSerializationServices() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.valueSerializationServices == null) {
                this.refresh((ModelProperty)PROP_VALUE_SERIALIZATION_SERVICES, true);
            }
            return this.valueSerializationServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_FUNCTIONS) {
                if (this.functions == null) {
                    if (force) {
                        this.functions = new ModelElementList((IModelElement)this, PROP_FUNCTIONS);
                        ListBindingImpl binding = this.resource().binding(PROP_FUNCTIONS);
                        this.functions.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_FUNCTIONS);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_FUNCTIONS);
                    boolean notified = this.functions.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_FUNCTIONS);
                    }
                }
            } else if (property == PROP_MODEL_ELEMENT_SERVICES) {
                if (this.modelElementServices == null) {
                    if (force) {
                        this.modelElementServices = new ModelElementList((IModelElement)this, PROP_MODEL_ELEMENT_SERVICES);
                        ListBindingImpl binding = this.resource().binding(PROP_MODEL_ELEMENT_SERVICES);
                        this.modelElementServices.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_MODEL_ELEMENT_SERVICES);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_MODEL_ELEMENT_SERVICES);
                    boolean notified = this.modelElementServices.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_MODEL_ELEMENT_SERVICES);
                    }
                }
            } else if (property == PROP_MODEL_PROPERTY_SERVICES) {
                if (this.modelPropertyServices == null) {
                    if (force) {
                        this.modelPropertyServices = new ModelElementList((IModelElement)this, PROP_MODEL_PROPERTY_SERVICES);
                        ListBindingImpl binding = this.resource().binding(PROP_MODEL_PROPERTY_SERVICES);
                        this.modelPropertyServices.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_MODEL_PROPERTY_SERVICES);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_MODEL_PROPERTY_SERVICES);
                    boolean notified = this.modelPropertyServices.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_MODEL_PROPERTY_SERVICES);
                    }
                }
            } else if (property == PROP_VALUE_SERIALIZATION_SERVICES) {
                if (this.valueSerializationServices == null) {
                    if (force) {
                        this.valueSerializationServices = new ModelElementList((IModelElement)this, PROP_VALUE_SERIALIZATION_SERVICES);
                        ListBindingImpl binding = this.resource().binding(PROP_VALUE_SERIALIZATION_SERVICES);
                        this.valueSerializationServices.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_VALUE_SERIALIZATION_SERVICES);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_VALUE_SERIALIZATION_SERVICES);
                    boolean notified = this.valueSerializationServices.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_VALUE_SERIALIZATION_SERVICES);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_FUNCTIONS) {
            return this.getFunctions();
        }
        if (property == PROP_MODEL_ELEMENT_SERVICES) {
            return this.getModelElementServices();
        }
        if (property == PROP_MODEL_PROPERTY_SERVICES) {
            return this.getModelPropertyServices();
        }
        if (property == PROP_VALUE_SERIALIZATION_SERVICES) {
            return this.getValueSerializationServices();
        }
        return super.read(property);
    }
}

