/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.doc.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerFactoryDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyFolderBrowseHandlerFactory
extends SapphireActionHandlerFactory {
    private File folder;

    public void init(SapphireAction action, ISapphireActionHandlerFactoryDef def) {
        super.init(action, def);
        this.folder = new File(def.getParam("folder"));
    }

    public List<SapphireActionHandler> create() {
        ArrayList<SapphireActionHandler> handlers = new ArrayList<SapphireActionHandler>();
        File[] fileArray = this.folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                handlers.add((SapphireActionHandler)new Handler(file));
            }
            ++n2;
        }
        return handlers;
    }

    private static class Handler
    extends SapphireBrowseActionHandler {
        private final File file;

        public Handler(File file) {
            this.file = file;
            this.setLabel(this.file.getName());
        }

        protected String browse(SapphireRenderingContext context) {
            return this.file.getAbsolutePath();
        }
    }
}

