/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NonNullValue;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.java.JavaTypeConstraints;
import org.eclipse.sapphire.modeling.java.JavaTypeKind;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;
import org.eclipse.sapphire.ui.def.ISapphireActionSystemPartDef;
import org.eclipse.sapphire.ui.def.ISapphireParam;
import org.eclipse.sapphire.ui.def.internal.SapphireActionHandlerDefMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Label(standard="action handler")
@GenerateImpl
public interface ISapphireActionHandlerDef
extends ISapphireActionSystemPartDef {
    public static final ModelElementType TYPE = new ModelElementType(ISapphireActionHandlerDef.class);
    @Label(standard="action")
    @NonNullValue
    @XmlBinding(path="action")
    @Documentation(content="The ID of the action that this handler is for.")
    public static final ValueProperty PROP_ACTION = new ValueProperty(TYPE, "Action");
    @Label(standard="ID", full="action handler ID")
    @Documentation(content="An action handler ID serves to uniquely identify an action for a variety of purposes, such as controlling ordering of action handlers via location hints. An ID only needs to be unique in the contexts where the action handler is expected to be used. To help avoid conflicts with other extensions, prefix the ID with company, organization or product name.[pbr/]Note that action handler ID can also be set in the implementation.")
    public static final ValueProperty PROP_ID = new ValueProperty(TYPE, ISapphireActionSystemPartDef.PROP_ID);
    @Label(standard="label", full="action handler label")
    @Documentation(content="An action handler label is used when presenting the action handler to the user.[pbr/]The exact way that the label is used is dependent on the presentation, but typical presentations use labels for menu item names and as tooltips.[pbr/]A label should only capitalize words that must remain capitalized regardless of context (proper nouns and acronyms). Words that are not already capitalized will be capitalized as necessary depending on how the label is used by the presentation.[pbr/]Note that action handler label can also be set in the implementation.")
    public static final ValueProperty PROP_LABEL = new ValueProperty(TYPE, ISapphireActionSystemPartDef.PROP_LABEL);
    @Documentation(content="One or more images can be associated with an action handler to be used by the presentation as appropriate. If an image is necessary, the presentation will look for an image of the appropriate size.[pbr/]Note that images can also be set in the implementation.")
    public static final ListProperty PROP_IMAGES = new ListProperty(TYPE, ISapphireActionSystemPartDef.PROP_IMAGES);
    @Documentation(content="Provides more information about the action handler than what is available in the label. The description should be in the form of properly capitalized and punctuated sentences.")
    public static final ValueProperty PROP_DESCRIPTION = new ValueProperty(TYPE, ISapphireActionSystemPartDef.PROP_DESCRIPTION);
    @Reference(target=Class.class)
    @Label(standard="implementation class")
    @NonNullValue
    @JavaTypeConstraints(kind={JavaTypeKind.CLASS}, type={"org.eclipse.sapphire.ui.SapphireActionHandler"})
    @MustExist
    @XmlBinding(path="impl")
    @Documentation(content="The action handler implementation class. Must extend SapphireActionHandler.")
    public static final ValueProperty PROP_IMPL_CLASS = new ValueProperty(TYPE, "ImplClass");
    @Type(base=ISapphireParam.class)
    @Label(standard="params")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="param", type=ISapphireParam.class)})
    @Documentation(content="Parameters that can be interpreted by the action handler.")
    public static final ListProperty PROP_PARAMS = new ListProperty(TYPE, "Params");
    @Documentation(content="A condition allows use of arbitrary logic to control whether the action handler is going to be available or not in a given situation. Conditions must extends SapphireCondition class.")
    public static final ValueProperty PROP_CONDITION_CLASS = new ValueProperty(TYPE, ISapphireActionSystemPartDef.PROP_CONDITION_CLASS);
    @Documentation(content="Every UI part that supports actions will define one or more context. An action handler can be constrained to apply only to the specified contexts. If no context is specified, the action handler will be treated as applicable to all contexts.")
    public static final ListProperty PROP_CONTEXTS = new ListProperty(TYPE, ISapphireActionSystemPartDef.PROP_CONTEXTS);
    @Documentation(content="Location hints are used to arrange action handlers in relation to each other. The location hints are expressed in terms of preference for whether this action handler should appear before or after another action handler. Multiple hints can be specified to precisely position an action handler.[pbr/]Note that ordering is particularly important for action handlers as certain presentations are only capable of presenting one handler for an action. Those presentations will use the first handler from the ordering imposed by the location hints.")
    public static final ListProperty PROP_LOCATION_HINTS = new ListProperty(TYPE, ISapphireActionSystemPartDef.PROP_LOCATION_HINTS);

    public Value<String> getAction();

    public void setAction(String var1);

    public ReferenceValue<Class<?>> getImplClass();

    public void setImplClass(String var1);

    public ModelElementList<ISapphireParam> getParams();

    @DelegateImplementation(value=SapphireActionHandlerDefMethods.class)
    public String getParam(String var1);
}

