/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def;

import org.eclipse.sapphire.modeling.BundleResourceStore;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.SharedModelsCache;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.def.ISapphireCompositeDef;
import org.eclipse.sapphire.ui.def.ISapphireDialogDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

public final class SapphireUiDefFactory {
    public static ISapphireUiDef load(String bundleId, String path) {
        try {
            return SapphireUiDefFactory.load(new XmlResourceStore((ByteArrayResourceStore)new BundleResourceStore(bundleId, path)), false);
        }
        catch (ResourceStoreException e) {
            SapphireUiFrameworkPlugin.log(e);
            return null;
        }
    }

    public static ISapphireUiDef load(XmlResourceStore resourceStore, boolean writable) {
        ISapphireUiDef model;
        if (writable) {
            model = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
        } else {
            SharedModelsCache.StandardKey key = new SharedModelsCache.StandardKey((ResourceStore)resourceStore, ISapphireUiDef.TYPE);
            model = (ISapphireUiDef)SharedModelsCache.retrieve((Object)key);
            if (model == null) {
                model = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
                SharedModelsCache.store((Object)key, (IModelElement)model);
            }
        }
        return model;
    }

    public static ISapphireCompositeDef getCompositeDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getCompositeDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireCompositeDef getCompositeDef(String bundleId, String defFilePath, String compositeId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return def.getCompositeDef(compositeId, true);
    }

    public static ISapphireDialogDef getDialogDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getDialogDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireDialogDef getDialogDef(String bundleId, String defFilePath, String wizardId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return def.getDialogDef(wizardId, true);
    }

    public static ISapphireWizardDef getWizardDef(String path) {
        String[] segments = SapphireUiDefFactory.parseDefPath(path);
        return SapphireUiDefFactory.getWizardDef(segments[0], segments[1], segments[2]);
    }

    public static ISapphireWizardDef getWizardDef(String bundleId, String defFilePath, String wizardId) {
        ISapphireUiDef def = SapphireUiDefFactory.load(bundleId, defFilePath);
        return def.getWizardDef(wizardId, true);
    }

    private static String[] parseDefPath(String path) {
        int firstSeparator = path.indexOf(47);
        int secondSeparator = path.lastIndexOf(33);
        int lastIndex = path.length() - 1;
        if (firstSeparator <= 0 || firstSeparator >= lastIndex || secondSeparator <= 0 || secondSeparator >= lastIndex || firstSeparator > secondSeparator) {
            throw new IllegalArgumentException();
        }
        String bundleId = path.substring(0, firstSeparator);
        String defFilePath = path.substring(firstSeparator + 1, secondSeparator);
        String compositeId = path.substring(secondSeparator + 1);
        return new String[]{bundleId, defFilePath, compositeId};
    }
}

