/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.def.IDefinitionReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefinitionReference
extends ModelElement
implements IDefinitionReference {
    private Value<String> path;

    public DefinitionReference(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public DefinitionReference(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getPath() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.path == null) {
                this.refresh((ModelProperty)PROP_PATH, true);
            }
            return this.path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPath(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_PATH.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_PATH, true);
            if (!DefinitionReference.equal((String)this.path.getText(false), (String)value)) {
                this.resource().binding(PROP_PATH).write(value);
                this.refresh((ModelProperty)PROP_PATH, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_PATH && (this.path != null || force)) {
                Value<String> oldValue = this.path;
                String val = this.resource().binding(PROP_PATH).read();
                this.path = new Value((IModelElement)this, PROP_PATH, PROP_PATH.encodeKeywords(val));
                this.path.init();
                boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PATH);
                if (oldValue != null) {
                    if (this.path.equals(oldValue)) {
                        this.path = oldValue;
                    }
                    if (this.path != oldValue || propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_PATH);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_PATH) {
            return this.getPath();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_PATH) {
            this.setPath((String)value);
            return;
        }
        super.write(property, value);
    }
}

