/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.IImportDirective;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.sapphire.ui.def.internal.ImportDirectiveMethods;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportDirective
extends ModelElement
implements IImportDirective {
    private Value<String> bundle;
    private ModelElementList<IDefinitionReference> definitions;
    private ModelElementList<IPackageReference> packages;

    public ImportDirective(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ImportDirective(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getBundle() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.bundle == null) {
                this.refresh((ModelProperty)PROP_BUNDLE, true);
            }
            return this.bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_BUNDLE.decodeKeywords(value);
            this.refresh((ModelProperty)PROP_BUNDLE, true);
            if (!ImportDirective.equal((String)this.bundle.getText(false), (String)value)) {
                this.resource().binding(PROP_BUNDLE).write(value);
                this.refresh((ModelProperty)PROP_BUNDLE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IDefinitionReference> getDefinitions() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.definitions == null) {
                this.refresh((ModelProperty)PROP_DEFINITIONS, true);
            }
            return this.definitions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IPackageReference> getPackages() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.packages == null) {
                this.refresh((ModelProperty)PROP_PACKAGES, true);
            }
            return this.packages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class resolveClass(String className) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return ImportDirectiveMethods.resolveClass(this, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageDescriptor resolveImage(String imagePath) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            return ImportDirectiveMethods.resolveImage(this, imagePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_BUNDLE) {
                if (this.bundle != null || force) {
                    Value<String> oldValue = this.bundle;
                    String val = this.resource().binding(PROP_BUNDLE).read();
                    this.bundle = new Value((IModelElement)this, PROP_BUNDLE, PROP_BUNDLE.encodeKeywords(val));
                    this.bundle.init();
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_BUNDLE);
                    if (oldValue != null) {
                        if (this.bundle.equals(oldValue)) {
                            this.bundle = oldValue;
                        }
                        if (this.bundle != oldValue || propertyEnabledStatusChanged) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_BUNDLE);
                        }
                    }
                }
            } else if (property == PROP_DEFINITIONS) {
                if (this.definitions == null) {
                    if (force) {
                        this.definitions = new ModelElementList((IModelElement)this, PROP_DEFINITIONS);
                        ListBindingImpl binding = this.resource().binding(PROP_DEFINITIONS);
                        this.definitions.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_DEFINITIONS);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_DEFINITIONS);
                    boolean notified = this.definitions.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DEFINITIONS);
                    }
                }
            } else if (property == PROP_PACKAGES) {
                if (this.packages == null) {
                    if (force) {
                        this.packages = new ModelElementList((IModelElement)this, PROP_PACKAGES);
                        ListBindingImpl binding = this.resource().binding(PROP_PACKAGES);
                        this.packages.init(binding);
                        this.refreshPropertyEnabledStatus((ModelProperty)PROP_PACKAGES);
                    }
                } else {
                    boolean propertyEnabledStatusChanged = this.refreshPropertyEnabledStatus((ModelProperty)PROP_PACKAGES);
                    boolean notified = this.packages.refresh();
                    if (!notified && propertyEnabledStatusChanged) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_PACKAGES);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_BUNDLE) {
            return this.getBundle();
        }
        if (property == PROP_DEFINITIONS) {
            return this.getDefinitions();
        }
        if (property == PROP_PACKAGES) {
            return this.getPackages();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_BUNDLE) {
            this.setBundle((String)value);
            return;
        }
        super.write(property, value);
    }
}

