/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.ui.def.IImportDirective;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImportDirectiveMethods {
    public static Class<?> resolveClass(IImportDirective directive, String className) {
        Bundle bundle;
        String bundleId = directive.getBundle().getText();
        if (bundleId != null && (bundle = Platform.getBundle((String)bundleId)) != null) {
            for (IPackageReference packageRef : directive.getPackages()) {
                String packageName = packageRef.getName().getText();
                if (packageName == null) continue;
                String fullClassName = String.valueOf(packageName) + "." + className;
                try {
                    return bundle.loadClass(fullClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return null;
    }

    public static Class<?> resolveClass(String className, String bundleId, String ... packageNames) {
        Bundle bundle;
        if (bundleId != null && (bundle = Platform.getBundle((String)bundleId)) != null) {
            String[] stringArray = packageNames;
            int n = packageNames.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                String fullClassName = String.valueOf(packageName) + "." + className;
                try {
                    return bundle.loadClass(fullClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ++n2;
                }
            }
        }
        return null;
    }

    public static ImageDescriptor resolveImage(IImportDirective directive, String imagePath) {
        String bundleId = directive.getBundle().getText();
        if (bundleId != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)bundleId, (String)imagePath);
        }
        return null;
    }
}

