/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer.actions;

import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireBrowseActionHandler;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.PlatformUI;

public final class AbsoluteFolderPathBrowseActionHandler
extends SapphireBrowseActionHandler {
    public static final String ID = "Sapphire.Browse.Folder.Absolute";

    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.setId(ID);
        this.setLabel(Resources.label);
        this.addImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
    }

    protected String browse(SapphireRenderingContext context) {
        ValueProperty property = this.getProperty();
        DirectoryDialog dialog = new DirectoryDialog(context.getShell());
        dialog.setText(property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false));
        dialog.setMessage(this.createBrowseDialogMessage(property.getLabel(true, CapitalizationType.NO_CAPS, false)));
        Value value = this.getModelElement().read(property);
        IPath path = (IPath)value.getContent();
        if (path != null) {
            dialog.setFilterPath(path.toOSString());
        }
        return dialog.open();
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)AbsoluteFolderPathBrowseActionHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

