/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.EnablementService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElementDisposedEvent;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelElementService;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelParticle;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.modeling.ModelPropertyListener;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelService;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.ValidationStateChangeEvent;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.ClearOnDisable;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElement
extends ModelParticle
implements IModelElement {
    private final ModelElementType type;
    private final ModelProperty parentProperty;
    private Status valres;
    private Set<ModelElementListener> listeners;
    private Map<ModelProperty, Set<ModelPropertyListener>> propertyListeners;
    private final Map<ModelProperty, Boolean> enablementStatuses;
    private boolean enablementServicesInitialized;
    private final Map<Class<? extends ModelElementService>, Collection<ModelElementService>> elementServices;
    private final Map<ModelProperty, Map<Class<? extends ModelPropertyService>, Collection<ModelPropertyService>>> propertyServices;

    public ModelElement(ModelElementType type, IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(parent, resource);
        this.type = type;
        this.parentProperty = parentProperty;
        this.valres = null;
        this.listeners = null;
        this.propertyListeners = null;
        this.enablementStatuses = new HashMap<ModelProperty, Boolean>();
        this.elementServices = new HashMap<Class<? extends ModelElementService>, Collection<ModelElementService>>();
        this.propertyServices = new HashMap<ModelProperty, Map<Class<? extends ModelPropertyService>, Collection<ModelPropertyService>>>();
        resource.init(this);
        final HashMap<ModelProperty, 1> refreshListeners = new HashMap<ModelProperty, 1>();
        for (final ModelProperty property : type.getProperties()) {
            ModelProperty prop;
            PossibleValuesService possibleValuesProvider;
            ModelPropertyListener listener;
            Set<ModelPath> dependencies = property.getDependencies();
            if (!dependencies.isEmpty()) {
                listener = new ModelPropertyListener(){

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        ModelElement.this.refresh(property);
                    }
                };
                refreshListeners.put(property, listener);
                for (ModelPath depPath : dependencies) {
                    this.addListener(listener, depPath);
                }
            }
            if (property instanceof ValueProperty && (possibleValuesProvider = this.service(property, PossibleValuesService.class)) != null) {
                possibleValuesProvider.addListener(new ModelService.Listener(){

                    public void handleEvent(ModelService.Event event) {
                        if (event instanceof PossibleValuesService.PossibleValuesChangedEvent) {
                            ModelElement.this.refresh(property);
                        }
                    }
                });
            }
            if (!property.hasAnnotation(ClearOnDisable.class)) continue;
            listener = null;
            if (property instanceof ValueProperty) {
                prop = (ValueProperty)property;
                listener = new ModelPropertyListener((ValueProperty)prop){
                    private final /* synthetic */ ValueProperty val$prop;
                    {
                        this.val$prop = valueProperty;
                    }

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        if (event.getOldEnablementState() && !event.getNewEnablementState()) {
                            ModelElement.this.write(this.val$prop, null);
                        }
                    }
                };
            } else if (property instanceof ListProperty) {
                prop = (ListProperty)property;
                listener = new ModelPropertyListener((ListProperty)prop){
                    private final /* synthetic */ ListProperty val$prop;
                    {
                        this.val$prop = listProperty;
                    }

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        if (event.getOldEnablementState() && !event.getNewEnablementState()) {
                            ModelElement.this.read(this.val$prop).clear();
                        }
                    }
                };
            } else if (property instanceof ElementProperty && !(property instanceof ImpliedElementProperty)) {
                prop = (ElementProperty)property;
                listener = new ModelPropertyListener((ElementProperty)prop){
                    private final /* synthetic */ ElementProperty val$prop;
                    {
                        this.val$prop = elementProperty;
                    }

                    public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
                        if (event.getOldEnablementState() && !event.getNewEnablementState()) {
                            ModelElement.this.read(this.val$prop).remove();
                        }
                    }
                };
            }
            if (listener == null) continue;
            this.addListener(listener, property.getName());
        }
        if (!refreshListeners.isEmpty()) {
            ModelElementListener disposeListener = new ModelElementListener(){

                public void handleElementDisposedEvent(ModelElementDisposedEvent event) {
                    for (Map.Entry entry : refreshListeners.entrySet()) {
                        ModelProperty property = (ModelProperty)entry.getKey();
                        ModelPropertyListener listener = (ModelPropertyListener)entry.getValue();
                        for (ModelPath depPath : property.getDependencies()) {
                            ModelElement.this.removeListener(listener, depPath);
                        }
                    }
                }
            };
            this.addListener(disposeListener);
        }
    }

    @Override
    public ModelElementType getModelElementType() {
        return this.type;
    }

    @Override
    public ModelProperty getParentProperty() {
        return this.parentProperty;
    }

    @Override
    public Object read(ModelProperty property) {
        String msg = NLS.bind(Resources.cannotReadProperty, property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public final <T> Value<T> read(ValueProperty property) {
        return (Value)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> ModelElementHandle<T> read(ElementProperty property) {
        return (ModelElementHandle)this.read((ModelProperty)property);
    }

    @Override
    public final <T extends IModelElement> T read(ImpliedElementProperty property) {
        return (T)((IModelElement)this.read((ModelProperty)property));
    }

    @Override
    public final <T extends IModelElement> ModelElementList<T> read(ListProperty property) {
        return (ModelElementList)this.read((ModelProperty)property);
    }

    @Override
    public final <T> Transient<T> read(TransientProperty property) {
        return (Transient)this.read((ModelProperty)property);
    }

    @Override
    public final SortedSet<String> read(ModelPath path) {
        TreeSet<String> result = new TreeSet<String>();
        this.read(path, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read(ModelPath path, Collection<String> result) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).read(path.tail(), result);
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).read(path.tail(), result);
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.getParentProperty().getName()).append(path.tail());
                ((IModelElement)parent).read(p, result);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.getModelElementType().getProperties()) {
                    Object obj = this.read(property);
                    if (obj instanceof Value) {
                        String val = ((Value)obj).getText();
                        if (val == null) continue;
                        result.add(val);
                        continue;
                    }
                    if (obj instanceof IModelElement) {
                        ((IModelElement)obj).read(path, result);
                        continue;
                    }
                    if (!(obj instanceof ModelElementList)) continue;
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path, result);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.getModelElementType().getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.read(path.tail(), result);
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.getModelElementType().getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Object obj = this.read(property);
                if (obj instanceof Value) {
                    String val = ((Value)obj).getText();
                    if (val != null) {
                        result.add(val);
                    }
                    if (path.length() != 1) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                } else if (obj instanceof IModelElement) {
                    ((IModelElement)obj).read(path.tail(), result);
                } else if (obj instanceof ModelElementList) {
                    for (IModelElement entry : (ModelElementList)obj) {
                        entry.read(path.tail(), result);
                    }
                }
            }
        }
    }

    @Override
    public void write(ValueProperty property, Object value) {
        String msg = NLS.bind(Resources.cannotWriteProperty, property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public void write(TransientProperty property, Object value) {
        String msg = NLS.bind(Resources.cannotWriteProperty, property.getName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    public final void refresh() {
        this.refresh(false, false);
    }

    @Override
    public final void refresh(boolean force) {
        this.refresh(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh(boolean force, boolean deep) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            for (ModelProperty property : this.getModelElementType().getProperties()) {
                this.refresh(property, force, deep);
            }
        }
    }

    @Override
    public final void refresh(ModelProperty property) {
        this.refresh(property, false, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force) {
        this.refresh(property, force, false);
    }

    @Override
    public final void refresh(ModelProperty property, boolean force, boolean deep) {
        this.refreshProperty(property, force);
        if (deep) {
            if (property instanceof ElementProperty) {
                Object child = property instanceof ImpliedElementProperty ? this.read((ImpliedElementProperty)property) : this.read((ElementProperty)property).element();
                if (child != null) {
                    child.refresh(force, true);
                }
            } else if (property instanceof ListProperty) {
                for (IModelElement child : this.read((ListProperty)property)) {
                    child.refresh(force, true);
                }
            }
        }
    }

    protected void refreshProperty(ModelProperty property, boolean force) {
    }

    @Override
    public final <S extends ModelElementService> S service(Class<S> serviceType) {
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (ModelElementService)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends ModelElementService> List<S> services(Class<S> serviceType) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Collection<ModelElementService> services = this.elementServices.get(serviceType);
            if (services == null) {
                Services servicesAnnotation;
                HashMap<String, SapphireModelingExtensionSystem.ModelElementServiceFactoryProxy> applicable = new HashMap<String, SapphireModelingExtensionSystem.ModelElementServiceFactoryProxy>();
                for (SapphireModelingExtensionSystem.ModelElementServiceFactoryProxy factory : SapphireModelingExtensionSystem.getModelElementServices()) {
                    if (!factory.applicable(this, serviceType)) continue;
                    applicable.put(factory.id(), factory);
                }
                for (SapphireModelingExtensionSystem.ModelElementServiceFactoryProxy factory : new ArrayList(applicable.values())) {
                    for (String overriddenServiceId : factory.overrides()) {
                        applicable.remove(overriddenServiceId);
                    }
                }
                ArrayList<ModelElementService> list = new ArrayList<ModelElementService>();
                ArrayList<Service> serviceAnnotations = new ArrayList<Service>();
                Service serviceAnnotation = this.type.getAnnotation(Service.class);
                if (serviceAnnotation != null) {
                    serviceAnnotations.add(serviceAnnotation);
                }
                if ((servicesAnnotation = this.type.getAnnotation(Services.class)) != null) {
                    Service[] serviceArray = servicesAnnotation.value();
                    int n = serviceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Service svc = serviceArray[n2];
                        serviceAnnotations.add(svc);
                        ++n2;
                    }
                }
                for (Service svc : serviceAnnotations) {
                    Class<? extends ModelService> cl = svc.impl();
                    if (!serviceType.isAssignableFrom(cl)) continue;
                    ModelElementService instance = null;
                    try {
                        instance = (ModelElementService)cl.newInstance();
                        instance.init(this, svc.params());
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                    if (instance == null) continue;
                    String[] stringArray = svc.overrides();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String overriddenServiceId = stringArray[n3];
                        applicable.remove(overriddenServiceId);
                        ++n3;
                    }
                    list.add(instance);
                }
                for (SapphireModelingExtensionSystem.ModelElementServiceFactoryProxy factory : applicable.values()) {
                    try {
                        ModelElementService service = factory.create(this, serviceType);
                        if (service == null) continue;
                        service.init(this, new String[0]);
                        list.add(service);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
                int count = list.size();
                services = count == 0 ? Collections.emptyList() : (count == 1 ? Collections.singletonList((ModelElementService)list.get(0)) : Collections.unmodifiableList(list));
                this.elementServices.put(serviceType, services);
            }
            return (List)services;
        }
    }

    @Override
    public final <S extends ModelPropertyService> S service(ModelProperty property, Class<S> serviceType) {
        List<S> services = this.services(property, serviceType);
        return (S)(services.isEmpty() ? null : (ModelPropertyService)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends ModelPropertyService> List<S> services(ModelProperty property, Class<S> serviceType) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Collection<ModelPropertyService> services;
            Map<Class<? extends ModelPropertyService>, Collection<ModelPropertyService>> typeToServicesMap = this.propertyServices.get(property);
            if (typeToServicesMap == null) {
                typeToServicesMap = new HashMap<Class<? extends ModelPropertyService>, Collection<ModelPropertyService>>();
                this.propertyServices.put(property, typeToServicesMap);
            }
            if ((services = typeToServicesMap.get(serviceType)) == null) {
                Services servicesAnnotation;
                HashMap<String, SapphireModelingExtensionSystem.ModelPropertyServiceFactoryProxy> applicable = new HashMap<String, SapphireModelingExtensionSystem.ModelPropertyServiceFactoryProxy>();
                for (SapphireModelingExtensionSystem.ModelPropertyServiceFactoryProxy factory : SapphireModelingExtensionSystem.getModelPropertyServices()) {
                    if (!factory.applicable(this, property, serviceType)) continue;
                    applicable.put(factory.id(), factory);
                }
                for (SapphireModelingExtensionSystem.ModelPropertyServiceFactoryProxy factory : new ArrayList(applicable.values())) {
                    for (String overriddenServiceId : factory.overrides()) {
                        applicable.remove(overriddenServiceId);
                    }
                }
                ArrayList<ModelPropertyService> list = new ArrayList<ModelPropertyService>();
                ArrayList<Service> serviceAnnotations = new ArrayList<Service>();
                Service serviceAnnotation = property.getAnnotation(Service.class);
                if (serviceAnnotation != null) {
                    serviceAnnotations.add(serviceAnnotation);
                }
                if ((servicesAnnotation = property.getAnnotation(Services.class)) != null) {
                    Service[] serviceArray = servicesAnnotation.value();
                    int n = serviceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Service svc = serviceArray[n2];
                        serviceAnnotations.add(svc);
                        ++n2;
                    }
                }
                for (Service svc : serviceAnnotations) {
                    Class<? extends ModelService> cl = svc.impl();
                    if (!serviceType.isAssignableFrom(cl)) continue;
                    ModelPropertyService instance = null;
                    try {
                        instance = (ModelPropertyService)cl.newInstance();
                        instance.init(this, property, svc.params());
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                    if (instance == null) continue;
                    String[] stringArray = svc.overrides();
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String overriddenServiceId = stringArray[n3];
                        applicable.remove(overriddenServiceId);
                        ++n3;
                    }
                    list.add(instance);
                }
                for (SapphireModelingExtensionSystem.ModelPropertyServiceFactoryProxy factory : applicable.values()) {
                    try {
                        ModelPropertyService service = factory.create(this, property, serviceType);
                        if (service == null) continue;
                        service.init(this, property, new String[0]);
                        list.add(service);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
                int count = list.size();
                services = count == 0 ? Collections.emptyList() : (count == 1 ? Collections.singletonList((ModelPropertyService)list.get(0)) : Collections.unmodifiableList(list));
                typeToServicesMap.put(serviceType, services);
            }
            return (List)services;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isPropertyEnabled(ModelProperty property) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Boolean status = this.enablementStatuses.get(property);
            if (status == null) {
                this.refreshPropertyEnablement(property, true);
                status = this.enablementStatuses.get(property);
            }
            return status;
        }
    }

    protected final EnablementRefreshResult refreshPropertyEnablement(ModelProperty property) {
        return this.refreshPropertyEnablement(property, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final EnablementRefreshResult refreshPropertyEnablement(ModelProperty property, boolean notifyListenersIfNecessary) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Boolean oldState;
            if (!this.enablementServicesInitialized) {
                for (final ModelProperty prop : this.type.getProperties()) {
                    ModelService.Listener enablementServiceListener = new ModelService.Listener(){

                        public void handleEvent(ModelService.Event event) {
                            if (event instanceof EnablementService.StateChangedEvent) {
                                ModelElement.this.refreshPropertyEnablement(prop, true);
                            }
                        }
                    };
                    for (EnablementService service : this.services(prop, EnablementService.class)) {
                        service.addListener(enablementServiceListener);
                    }
                }
                this.enablementServicesInitialized = true;
            }
            boolean newState = true;
            for (EnablementService service : this.services(property, EnablementService.class)) {
                boolean bl = newState = newState && service.state();
                if (!newState) break;
            }
            if ((oldState = this.enablementStatuses.get(property)) == null) {
                this.enablementStatuses.put(property, newState);
            } else if (!oldState.equals(newState)) {
                this.enablementStatuses.put(property, newState);
                if (notifyListenersIfNecessary) {
                    this.notifyPropertyChangeListeners(new ModelPropertyChangeEvent(this, property, oldState, newState));
                }
            }
            return new EnablementRefreshResult(oldState, newState);
        }
    }

    @Override
    public Status validate() {
        if (this.valres == null) {
            this.refreshValidationResult();
        }
        return this.valres;
    }

    private void refreshValidationResult() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (ModelProperty property : this.type.getProperties()) {
            Status x;
            if (!this.isPropertyEnabled(property)) continue;
            if (property instanceof ValueProperty) {
                x = this.read((ValueProperty)property).validate();
            } else if (property instanceof ListProperty) {
                x = this.read((ListProperty)property).validate();
            } else if (property instanceof ImpliedElementProperty) {
                x = this.read((ImpliedElementProperty)property).validate();
            } else if (property instanceof ElementProperty) {
                x = this.read((ElementProperty)property).validate();
            } else if (property instanceof TransientProperty) {
                x = this.read((TransientProperty)property).validate();
            } else {
                throw new IllegalStateException();
            }
            factory.add(x);
        }
        Status st = factory.create();
        if (this.valres == null) {
            this.valres = st;
        } else if (!this.valres.equals(st)) {
            Status oldValidationState = this.valres;
            this.valres = st;
            this.notifyValidationStateChangeListeners(oldValidationState, this.valres);
            IModelParticle parent = this.parent();
            if (parent != null && parent instanceof IModelElement) {
                ((IModelElement)parent).notifyPropertyChangeListeners(this.parentProperty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ModelElementListener listener) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteArraySet<ModelElementListener>();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public final void addListener(ModelPropertyListener listener, String path) {
        this.addListener(listener, new ModelPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addListener(ModelPropertyListener listener, ModelPath path) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).addListener(listener, path.tail());
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).addListener(listener, path.tail());
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
                ((IModelElement)parent).addListener(listener, p);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.type.getProperties()) {
                    PropagationListener pListener;
                    Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                    listeners.add(listener);
                    if (!(property instanceof ListProperty) && !(property instanceof ElementProperty) || !listeners.add(pListener = new PropagationListener(property, path, listener))) continue;
                    pListener.handlePropertyChangedEvent(null);
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type.getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.addListener(listener, path.tail());
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.type.getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                if (path.length() == 1) {
                    listeners.add(listener);
                } else {
                    PropagationListener pListener;
                    if (property instanceof ValueProperty) {
                        this.logInvalidModelPathMessage(path);
                        return;
                    }
                    if ((property instanceof ListProperty || property instanceof ElementProperty) && listeners.add(pListener = new PropagationListener(property, path.tail(), listener))) {
                        pListener.handlePropertyChangedEvent(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ModelElementListener listener) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    @Override
    public final void removeListener(ModelPropertyListener listener, String path) {
        this.removeListener(listener, new ModelPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(ModelPropertyListener listener, ModelPath path) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            ModelPath.Segment head = path.head();
            if (head instanceof ModelPath.ModelRootSegment) {
                ((IModelElement)this.root()).removeListener(listener, path.tail());
            } else if (head instanceof ModelPath.ParentElementSegment) {
                IModelParticle parent = this.parent();
                if (parent == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                if (parent instanceof ModelElementList) {
                    parent = parent.parent();
                }
                ((IModelElement)parent).removeListener(listener, path.tail());
            } else if (head instanceof ModelPath.AllSiblingsSegment) {
                IModelParticle parent = this.parent();
                if (parent == null || !(parent instanceof ModelElementList)) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                parent = parent.parent();
                ModelPath p = new ModelPath(this.parentProperty.getName()).append(path.tail());
                ((IModelElement)parent).removeListener(listener, p);
            } else if (head instanceof ModelPath.AllDescendentsSegment) {
                for (ModelProperty property : this.type.getProperties()) {
                    Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                    listeners.remove(listener);
                    if (property instanceof ValueProperty) continue;
                    PropagationListener pListener = new PropagationListener(property, path, listener);
                    listeners.remove(pListener);
                    if (property instanceof ElementProperty) {
                        IModelElement element = null;
                        element = property instanceof ImpliedElementProperty ? (IModelElement)this.read((ImpliedElementProperty)property) : (IModelElement)this.read((ElementProperty)property).element();
                        if (element == null) continue;
                        element.removeListener(listener, path);
                        continue;
                    }
                    if (!(property instanceof ListProperty)) continue;
                    ModelElementList list = this.read((ListProperty)property);
                    for (IModelElement x : list) {
                        x.removeListener(listener, path);
                    }
                }
            } else if (head instanceof ModelPath.TypeFilterSegment) {
                String t = this.type.getSimpleName();
                boolean match = false;
                for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                    if (!type.equalsIgnoreCase(t)) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.removeListener(listener, path.tail());
                }
            } else {
                String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
                ModelProperty property = this.type.getProperty(propertyName);
                if (property == null) {
                    this.logInvalidModelPathMessage(path);
                    return;
                }
                Set<ModelPropertyListener> listeners = this.getListenersForEdit(property);
                if (path.length() == 1) {
                    listeners.remove(listener);
                } else {
                    PropagationListener pListener = new PropagationListener(property, path.tail(), listener);
                    listeners.remove(pListener);
                    ModelPath tail = path.tail();
                    if (property instanceof ElementProperty) {
                        IModelElement element = null;
                        element = property instanceof ImpliedElementProperty ? (IModelElement)this.read((ImpliedElementProperty)property) : (IModelElement)this.read((ElementProperty)property).element();
                        if (element != null) {
                            element.removeListener(listener, tail);
                        }
                    } else if (property instanceof ListProperty) {
                        ModelElementList list = this.read((ListProperty)property);
                        for (IModelElement x : list) {
                            x.removeListener(listener, tail);
                        }
                    }
                }
            }
        }
    }

    @Override
    public final void notifyPropertyChangeListeners(ModelProperty property) {
        boolean enabled = this.isPropertyEnabled(property);
        this.notifyPropertyChangeListeners(new ModelPropertyChangeEvent(this, property, enabled, enabled));
    }

    protected final void notifyPropertyChangeListeners(ModelProperty property, EnablementRefreshResult enablementRefreshResult) {
        this.notifyPropertyChangeListeners(new ModelPropertyChangeEvent(this, property, enablementRefreshResult.before(), enablementRefreshResult.after()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPropertyChangeListeners(ModelPropertyChangeEvent event) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            Set<ModelPropertyListener> set;
            if (this.valres != null) {
                this.refreshValidationResult();
            }
            if (this.listeners != null) {
                for (ModelElementListener modelElementListener : this.listeners) {
                    try {
                        modelElementListener.propertyChanged(event);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
            }
            if (this.propertyListeners != null && (set = this.propertyListeners.get(event.getProperty())) != null) {
                for (ModelPropertyListener listener : set) {
                    try {
                        listener.handlePropertyChangedEvent(event);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
            }
            for (ModelPropertyListener modelPropertyListener : event.getProperty().getListeners()) {
                try {
                    modelPropertyListener.handlePropertyChangedEvent(event);
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyValidationStateChangeListeners(Status oldValidationState, Status newValidationState) {
        ValidationStateChangeEvent event = new ValidationStateChangeEvent(this, oldValidationState, newValidationState);
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners != null) {
                for (ModelElementListener listener : this.listeners) {
                    try {
                        listener.validationStateChanged(event);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
            }
        }
    }

    private Set<ModelPropertyListener> getListenersForEdit(ModelProperty property) {
        Set<ModelPropertyListener> set;
        if (this.propertyListeners == null) {
            this.propertyListeners = new HashMap<ModelProperty, Set<ModelPropertyListener>>();
        }
        set = (set = this.propertyListeners.get(property)) == null ? new HashSet<ModelPropertyListener>() : new HashSet<ModelPropertyListener>(set);
        this.propertyListeners.put(property, set);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.listeners != null) {
                ModelElementDisposedEvent modelElementDisposedEvent = new ModelElementDisposedEvent(this);
                for (ModelElementListener listener : this.listeners) {
                    try {
                        listener.handleElementDisposedEvent(modelElementDisposedEvent);
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
            }
            for (ModelProperty modelProperty : this.type.getProperties()) {
                Object child2;
                if (modelProperty instanceof ListProperty) {
                    for (IModelElement child : this.read((ListProperty)modelProperty)) {
                        child.dispose();
                    }
                    continue;
                }
                if (modelProperty instanceof ImpliedElementProperty) {
                    this.read((ImpliedElementProperty)modelProperty).dispose();
                    continue;
                }
                if (!(modelProperty instanceof ElementProperty) || (child2 = this.read((ElementProperty)modelProperty).element(false)) == null) continue;
                child2.dispose();
            }
            try {
                this.resource().dispose();
            }
            catch (Exception exception) {
                LoggingService.log(exception);
            }
            for (Collection collection : this.elementServices.values()) {
                for (ModelElementService service : collection) {
                    try {
                        service.dispose();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
            }
            for (Map map : this.propertyServices.values()) {
                for (Collection list : map.values()) {
                    for (ModelPropertyService service : list) {
                        try {
                            service.dispose();
                        }
                        catch (Exception e) {
                            LoggingService.log(e);
                        }
                    }
                }
            }
        }
    }

    private void logInvalidModelPathMessage(ModelPath path) {
        String message = NLS.bind(Resources.invalidModelPath, this.type.getModelElementClass().getName(), path.toString());
        LoggingService.log(Status.createErrorStatus(message));
    }

    protected static final boolean equal(String value1, String value2) {
        String val1 = ModelElement.normalize(value1);
        String val2 = ModelElement.normalize(value2);
        boolean valuesAreEqual = false;
        if (val1 == val2) {
            valuesAreEqual = true;
        } else if (val1 != null && val2 != null) {
            valuesAreEqual = val1.equals(val2);
        }
        return valuesAreEqual;
    }

    protected static final String normalize(String value) {
        if (value != null && value.equals("")) {
            return null;
        }
        return value;
    }

    protected final class EnablementRefreshResult {
        private final Boolean oldEnablementState;
        private final boolean newEnablementState;

        public EnablementRefreshResult(Boolean before, boolean after) {
            this.oldEnablementState = before;
            this.newEnablementState = after;
        }

        public Boolean before() {
            return this.oldEnablementState;
        }

        public boolean after() {
            return this.newEnablementState;
        }

        public boolean changed() {
            if (this.oldEnablementState == null) {
                return false;
            }
            return this.oldEnablementState ^ this.newEnablementState;
        }
    }

    private final class PropagationListener
    extends ModelPropertyListener {
        private final ModelProperty property;
        private final ModelPath path;
        private final ModelPropertyListener listener;

        public PropagationListener(ModelProperty property, ModelPath path, ModelPropertyListener listener) {
            if (property instanceof ValueProperty) {
                throw new IllegalArgumentException();
            }
            this.property = property;
            this.path = path;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PropagationListener) {
                PropagationListener pl = (PropagationListener)obj;
                return this.property == pl.property && this.path.equals(pl.path) && this.listener == pl.listener;
            }
            return false;
        }

        public int hashCode() {
            return this.property.hashCode() ^ this.path.hashCode();
        }

        public void handlePropertyChangedEvent(ModelPropertyChangeEvent event) {
            if (this.property instanceof ElementProperty) {
                Object element = this.property instanceof ImpliedElementProperty ? ModelElement.this.read((ImpliedElementProperty)this.property) : ModelElement.this.read((ElementProperty)this.property).element();
                if (element != null) {
                    element.addListener(this.listener, this.path);
                }
            } else {
                ModelElementList list = ModelElement.this.read((ListProperty)this.property);
                for (IModelElement x : list) {
                    x.addListener(this.listener, this.path);
                }
            }
            this.listener.handlePropertyChangedEvent(event);
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidModelPath;
        public static String cannotReadProperty;
        public static String cannotWriteProperty;

        static {
            Resources.initializeMessages(ModelElement.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

