/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;

public class FailSafeFunction
extends Function {
    public static Function create(Function operand, Function expectedType) {
        return FailSafeFunction.create(operand, expectedType, Literal.NULL);
    }

    public static Function create(Function operand, Function expectedType, Function defaultValue) {
        if (operand == null) {
            operand = Literal.NULL;
        }
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        if (defaultValue == null) {
            defaultValue = Literal.NULL;
        }
        if (operand instanceof Literal && expectedType instanceof Literal && defaultValue instanceof Literal) {
            Object op = ((Literal)operand).value();
            Object et = ((Literal)expectedType).value();
            Object dv = ((Literal)defaultValue).value();
            if (dv == null && (op == null || op.getClass().equals(et))) {
                return operand;
            }
        }
        FailSafeFunction function = new FailSafeFunction();
        function.init(operand, expectedType, defaultValue);
        function.initOrigin(operand.origin(), false);
        return function;
    }

    public String name() {
        return "FailSafe";
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() {
                Object val = this.operand(0).value();
                if (val == null || val instanceof Value && ((Value)val).getContent() == null) {
                    val = this.operand(2).value();
                }
                try {
                    return this.cast(val, this.cast(this.operand(1).value(), Class.class));
                }
                catch (FunctionException e) {
                    return FailSafeFunction.this.handleFunctionException(e);
                }
            }
        };
    }

    protected Object handleFunctionException(FunctionException e) {
        return null;
    }
}

