/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.PossibleValuesService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumPossibleValuesService
extends PossibleValuesService {
    private final List<String> values = new ArrayList<String>();

    @Override
    public void init(IModelElement element, ModelProperty property, String[] params) {
        super.init(element);
        EnumValueType enumType = new EnumValueType(property.getTypeClass());
        ValueSerializationService valueSerializationService = element.service(property, ValueSerializationService.class);
        Enum<?>[] enumArray = enumType.getItems();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> item = enumArray[n2];
            this.values.add(valueSerializationService.encode(item));
            ++n2;
        }
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        values.addAll(this.values);
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.OK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && Enum.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new EnumPossibleValuesService();
        }
    }
}

