/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.validation.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ModelPropertyService;
import org.eclipse.sapphire.modeling.ModelPropertyServiceFactory;
import org.eclipse.sapphire.modeling.ModelPropertyValidationService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MalformedValueValidationService
extends ModelPropertyValidationService<Value<?>> {
    private String valueTypeName;

    @Override
    public Status validate() {
        Value value = (Value)this.target();
        if (value.isMalformed()) {
            if (this.valueTypeName == null) {
                Class<?> type = value.getProperty().getTypeClass();
                this.valueTypeName = LocalizationSystem.service(type).label(type, CapitalizationType.NO_CAPS, false);
            }
            String msg = NLS.bind(Resources.cannotParseValueMessage, this.valueTypeName, value.getText());
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ModelPropertyServiceFactory {
        @Override
        public boolean applicable(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return property instanceof ValueProperty && !String.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public ModelPropertyService create(IModelElement element, ModelProperty property, Class<? extends ModelPropertyService> service) {
            return new MalformedValueValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String cannotParseValueMessage;

        static {
            Resources.initializeMessages(MalformedValueValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

