/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.architecture.internal;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.samples.architecture.IComponent;
import org.eclipse.sapphire.samples.architecture.IComponentDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Component
extends ModelElement
implements IComponent {
    private ModelElementList<IComponentDependency> dependencies;
    private Value<String> description;
    private Value<String> name;

    public Component(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public Component(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<IComponentDependency> getDependencies() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.dependencies == null) {
                this.refresh((ModelProperty)PROP_DEPENDENCIES, true);
            }
            return this.dependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getDescription() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.description == null) {
                this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            }
            return this.description;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDescription(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_DESCRIPTION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_DESCRIPTION, true);
            if (!Component.equal((String)this.description.getText(false), (String)value)) {
                this.resource().binding(PROP_DESCRIPTION).write(value);
                this.refresh((ModelProperty)PROP_DESCRIPTION, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getName() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.name == null) {
                this.refresh((ModelProperty)PROP_NAME, true);
            }
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setName(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_NAME.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_NAME, true);
            if (!Component.equal((String)this.name.getText(false), (String)value)) {
                this.resource().binding(PROP_NAME).write(value);
                this.refresh((ModelProperty)PROP_NAME, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_DEPENDENCIES) {
                if (this.dependencies == null) {
                    if (force) {
                        this.dependencies = new ModelElementList((IModelElement)this, PROP_DEPENDENCIES);
                        ListBindingImpl binding = this.resource().binding(PROP_DEPENDENCIES);
                        this.dependencies.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_DEPENDENCIES);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DEPENDENCIES);
                    boolean notified = this.dependencies.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_DEPENDENCIES, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_DESCRIPTION) {
                if (this.description != null || force) {
                    Value<String> oldValue = this.description;
                    String val = this.resource().binding(PROP_DESCRIPTION).read();
                    this.description = new Value((IModelElement)this, PROP_DESCRIPTION, ((ValueNormalizationService)this.service((ModelProperty)PROP_DESCRIPTION, ValueNormalizationService.class)).normalize(PROP_DESCRIPTION.encodeKeywords(val)));
                    this.description.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_DESCRIPTION);
                    if (oldValue != null) {
                        if (this.description.equals(oldValue)) {
                            this.description = oldValue;
                        }
                        if (this.description != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_DESCRIPTION, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_NAME && (this.name != null || force)) {
                Value<String> oldValue = this.name;
                String val = this.resource().binding(PROP_NAME).read();
                this.name = new Value((IModelElement)this, PROP_NAME, ((ValueNormalizationService)this.service((ModelProperty)PROP_NAME, ValueNormalizationService.class)).normalize(PROP_NAME.encodeKeywords(val)));
                this.name.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_NAME);
                if (oldValue != null) {
                    if (this.name.equals(oldValue)) {
                        this.name = oldValue;
                    }
                    if (this.name != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_NAME, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_DEPENDENCIES) {
            return this.getDependencies();
        }
        if (property == PROP_DESCRIPTION) {
            return this.getDescription();
        }
        if (property == PROP_NAME) {
            return this.getName();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_DESCRIPTION) {
            this.setDescription((String)value);
            return;
        }
        if (property == PROP_NAME) {
            this.setName((String)value);
            return;
        }
        super.write(property, value);
    }
}

