/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.gallery.internal;

import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueNormalizationService;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.serialization.ValueSerializationService;
import org.eclipse.sapphire.samples.gallery.IChildElement;
import org.eclipse.sapphire.samples.gallery.IChildElementWithInteger;
import org.eclipse.sapphire.samples.gallery.IElementPropertiesGallery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementPropertiesGallery
extends ModelElement
implements IElementPropertiesGallery {
    private ModelElementHandle<IChildElement> heterogeneous;
    private ModelElementHandle<IChildElement> homogeneous;
    private ModelElementHandle<IChildElementWithInteger> implied;
    private Value<Integer> integerValue;
    private Value<String> stringValue;

    public ElementPropertiesGallery(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ElementPropertiesGallery(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<IChildElement> getHeterogeneous() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.heterogeneous == null) {
                this.refresh((ModelProperty)PROP_HETEROGENEOUS, true);
            }
            return this.heterogeneous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementHandle<IChildElement> getHomogeneous() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.homogeneous == null) {
                this.refresh((ModelProperty)PROP_HOMOGENEOUS, true);
            }
            return this.homogeneous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChildElementWithInteger getImplied() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.implied == null) {
                this.refresh((ModelProperty)PROP_IMPLIED, true);
            }
            return (IChildElementWithInteger)this.implied.element();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<Integer> getIntegerValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.integerValue == null) {
                this.refresh((ModelProperty)PROP_INTEGER_VALUE, true);
            }
            return this.integerValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIntegerValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_INTEGER_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_INTEGER_VALUE, true);
            if (!ElementPropertiesGallery.equal((String)this.integerValue.getText(false), (String)value)) {
                this.resource().binding(PROP_INTEGER_VALUE).write(value);
                this.refresh((ModelProperty)PROP_INTEGER_VALUE, false);
            }
        }
    }

    @Override
    public void setIntegerValue(Integer value) {
        this.setIntegerValue(value != null ? ((ValueSerializationService)this.service((ModelProperty)PROP_INTEGER_VALUE, ValueSerializationService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value<String> getStringValue() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.stringValue == null) {
                this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            }
            return this.stringValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringValue(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_STRING_VALUE.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_STRING_VALUE, true);
            if (!ElementPropertiesGallery.equal((String)this.stringValue.getText(false), (String)value)) {
                this.resource().binding(PROP_STRING_VALUE).write(value);
                this.refresh((ModelProperty)PROP_STRING_VALUE, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_HETEROGENEOUS) {
                if (this.heterogeneous == null) {
                    if (force) {
                        this.heterogeneous = new ModelElementHandle((IModelElement)this, PROP_HETEROGENEOUS);
                        this.heterogeneous.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_HETEROGENEOUS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_HETEROGENEOUS);
                    boolean notified = this.heterogeneous.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_HETEROGENEOUS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_HOMOGENEOUS) {
                if (this.homogeneous == null) {
                    if (force) {
                        this.homogeneous = new ModelElementHandle((IModelElement)this, PROP_HOMOGENEOUS);
                        this.homogeneous.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_HOMOGENEOUS);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_HOMOGENEOUS);
                    boolean notified = this.homogeneous.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_HOMOGENEOUS, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_IMPLIED) {
                if (this.implied == null) {
                    if (force) {
                        this.implied = new ModelElementHandle((IModelElement)this, (ElementProperty)PROP_IMPLIED);
                        this.implied.init();
                        this.refreshPropertyEnablement((ModelProperty)PROP_IMPLIED);
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_IMPLIED);
                    boolean notified = this.implied.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_IMPLIED, enablementRefreshResult);
                    }
                }
            } else if (property == PROP_INTEGER_VALUE) {
                if (this.integerValue != null || force) {
                    Value<Integer> oldValue = this.integerValue;
                    String val = this.resource().binding(PROP_INTEGER_VALUE).read();
                    this.integerValue = new Value((IModelElement)this, PROP_INTEGER_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_INTEGER_VALUE, ValueNormalizationService.class)).normalize(PROP_INTEGER_VALUE.encodeKeywords(val)));
                    this.integerValue.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_INTEGER_VALUE);
                    if (oldValue != null) {
                        if (this.integerValue.equals(oldValue)) {
                            this.integerValue = oldValue;
                        }
                        if (this.integerValue != oldValue || enablementRefreshResult.changed()) {
                            this.notifyPropertyChangeListeners((ModelProperty)PROP_INTEGER_VALUE, enablementRefreshResult);
                        }
                    }
                }
            } else if (property == PROP_STRING_VALUE && (this.stringValue != null || force)) {
                Value<String> oldValue = this.stringValue;
                String val = this.resource().binding(PROP_STRING_VALUE).read();
                this.stringValue = new Value((IModelElement)this, PROP_STRING_VALUE, ((ValueNormalizationService)this.service((ModelProperty)PROP_STRING_VALUE, ValueNormalizationService.class)).normalize(PROP_STRING_VALUE.encodeKeywords(val)));
                this.stringValue.init();
                ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_STRING_VALUE);
                if (oldValue != null) {
                    if (this.stringValue.equals(oldValue)) {
                        this.stringValue = oldValue;
                    }
                    if (this.stringValue != oldValue || enablementRefreshResult.changed()) {
                        this.notifyPropertyChangeListeners((ModelProperty)PROP_STRING_VALUE, enablementRefreshResult);
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_HETEROGENEOUS) {
            return this.getHeterogeneous();
        }
        if (property == PROP_HOMOGENEOUS) {
            return this.getHomogeneous();
        }
        if (property == PROP_IMPLIED) {
            return this.getImplied();
        }
        if (property == PROP_INTEGER_VALUE) {
            return this.getIntegerValue();
        }
        if (property == PROP_STRING_VALUE) {
            return this.getStringValue();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_INTEGER_VALUE) {
            if (!(value instanceof String)) {
                this.setIntegerValue((Integer)value);
            } else {
                this.setIntegerValue((String)value);
            }
            return;
        }
        if (property == PROP_STRING_VALUE) {
            this.setStringValue((String)value);
            return;
        }
        super.write(property, value);
    }
}

