/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.editor;

import java.util.List;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.graphiti.actions.SapphireActionHandlerDelegate;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;

public class SapphireDiagramEditorContextMenuProvider
extends ContextMenuProvider {
    private static final String DIAGRAM_NODE_DEFAULT_ACTION = "Sapphire.Diagram.Node.Default";
    private SapphireDiagramEditor sapphireDiagramEditor;

    public SapphireDiagramEditorContextMenuProvider(SapphireDiagramEditor sapphireEditor) {
        super((EditPartViewer)sapphireEditor.getGraphicalViewer());
        this.sapphireDiagramEditor = sapphireEditor;
    }

    public void buildContextMenu(IMenuManager menuMgr) {
        List<SapphirePart> selectedParts = this.sapphireDiagramEditor.getSelectedParts();
        if (selectedParts.size() == 1) {
            SapphirePart selectedPart = selectedParts.get(0);
            String actionContext = null;
            if (selectedPart instanceof SapphireDiagramEditorPagePart) {
                actionContext = "Sapphire.Diagram.Editor";
            } else if (selectedPart instanceof DiagramNodePart) {
                actionContext = "Sapphire.Diagram.Node";
            } else if (selectedPart instanceof DiagramConnectionPart) {
                actionContext = "Sapphire.Diagram.Connection";
            }
            SapphireActionGroup actionGroup = selectedPart.getActions(actionContext);
            for (SapphireAction action : actionGroup.getActions()) {
                if (action.getId().equals(DIAGRAM_NODE_DEFAULT_ACTION)) continue;
                this.addActionToContextMenu(menuMgr, action);
            }
        }
    }

    private void addActionToContextMenu(IMenuManager menuMgr, SapphireAction action) {
        if (action.getActiveHandlers().size() == 1) {
            SapphireActionHandler actionHandler = (SapphireActionHandler)action.getActiveHandlers().get(0);
            SapphireActionHandlerDelegate actionDelegate = new SapphireActionHandlerDelegate(this.sapphireDiagramEditor, actionHandler);
            menuMgr.add((IAction)actionDelegate);
        } else if (action.getActiveHandlers().size() > 1) {
            String menuText = LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            MenuManager addMenuMgr = new MenuManager(menuText, action.getImage(16), action.getId());
            addMenuMgr.setParent((IContributionManager)menuMgr);
            menuMgr.add((IContributionItem)addMenuMgr);
            for (SapphireActionHandler handler : action.getActiveHandlers()) {
                SapphireActionHandlerDelegate actionDelegate = new SapphireActionHandlerDelegate(this.sapphireDiagramEditor, handler);
                addMenuMgr.add((IAction)actionDelegate);
            }
        }
    }
}

