/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditorFactory;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.sapphire.modeling.StatusException;
import org.eclipse.sapphire.modeling.util.internal.FileUtil;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.swt.graphiti.GraphitiFileService;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditorInput;

public class SapphireDiagramEditorFactory {
    public static final String SAPPHIRE_DIAGRAM_TYPE = "sapphireDiagram";

    public static SapphireDiagramEditorInput createEditorInput(IFile file) throws StatusException, CoreException {
        return SapphireDiagramEditorFactory.createEditorInput(file, null, false);
    }

    public static SapphireDiagramEditorInput createEditorInput(IFile file, String diagramPageId, boolean sideBySideLayoutFile) throws StatusException, CoreException {
        IFolder layoutFolder;
        IFile layoutFile;
        IFolder diagramSettingRootFolder;
        IPath diagramSettingFolderPath;
        IFolder diagramSettingFolder;
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        IPath inputFilePath = file.getProjectRelativePath().removeLastSegments(1);
        String inputFileName = file.getName();
        String fileName = inputFileName.endsWith(".xml") ? inputFileName.substring(0, inputFileName.indexOf(".xml")) : inputFileName;
        if (diagramPageId != null) {
            fileName = String.valueOf(fileName) + "_" + diagramPageId;
        }
        if (!(diagramSettingFolder = project.getFolder(diagramSettingFolderPath = (diagramSettingRootFolder = project.getFolder(".settings/org.eclipse.sapphire.ui.diagram/")).getProjectRelativePath().append(inputFilePath))).exists()) {
            FileUtil.mkdirs((File)diagramSettingFolder.getLocation().toFile());
            diagramSettingFolder.refreshLocal(1, null);
        }
        if (!(layoutFile = (layoutFolder = !sideBySideLayoutFile ? diagramSettingFolder : (IFolder)file.getParent()).getFile(String.valueOf(fileName) + ".layout")).exists()) {
            layoutFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        }
        TransactionalEditingDomain domain = null;
        ResourceSet resourceSet = null;
        Diagram diagram = null;
        URI diagramFileUri = null;
        String diagramFileName = String.valueOf(fileName) + ".xmi";
        IFile diagramFile = diagramSettingFolder.getFile(diagramFileName);
        if (!diagramFile.exists()) {
            diagramFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            diagram = Graphiti.getPeCreateService().createDiagram(SAPPHIRE_DIAGRAM_TYPE, fileName, 10, true);
            diagramFileUri = URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true);
            domain = GraphitiFileService.createEmfFileForDiagram(diagramFileUri, diagram);
        } else {
            domain = DiagramEditorFactory.createResourceSetAndEditingDomain();
            resourceSet = domain.getResourceSet();
            diagramFileUri = GraphitiUiInternal.getEmfService().getFileURI(diagramFile, resourceSet);
            if (diagramFileUri != null) {
                Resource resource = resourceSet.createResource(diagramFileUri);
                try {
                    resource.load(null);
                }
                catch (IOException ie) {
                    SapphireUiFrameworkPlugin.log((Throwable)ie);
                }
                EList objs = resource.getContents();
                for (EObject obj : objs) {
                    if (obj == null && !Diagram.class.isInstance(obj)) continue;
                    diagram = (Diagram)obj;
                    break;
                }
            }
        }
        if (diagram != null) {
            String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
            SapphireDiagramEditorInput diagramEditorInput = SapphireDiagramEditorInput.createEditorInput(diagram, domain, providerId, false);
            diagramEditorInput.setLayoutFile(layoutFile);
            return diagramEditorInput;
        }
        return null;
    }
}

