/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.form.editors.masterdetails.internal;

import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementListener;
import org.eclipse.sapphire.modeling.ModelPropertyChangeEvent;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ISapphireActionHandlerDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentNode;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsContentOutline;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutlineNodeMoveActionHandler
extends SapphireActionHandler {
    private ModelElementListener listPropertyListener = null;
    private MasterDetailsContentOutline contentTree = null;
    private MasterDetailsContentOutline.Listener contentTreeListener = null;

    @Override
    public void init(SapphireAction action, ISapphireActionHandlerDef def) {
        super.init(action, def);
        this.contentTree = ((MasterDetailsContentNode)this.getPart()).getContentTree();
        this.contentTreeListener = new MasterDetailsContentOutline.Listener(){

            public void handleFilterChange(String newFilterText) {
                OutlineNodeMoveActionHandler.this.refreshEnabledState();
            }
        };
        this.contentTree.addListener(this.contentTreeListener);
        final Runnable op = new Runnable(){

            public void run() {
                OutlineNodeMoveActionHandler.this.refreshEnabledState();
            }
        };
        final ListProperty property = this.getList().getParentProperty();
        this.listPropertyListener = new ModelElementListener(){

            public void propertyChanged(ModelPropertyChangeEvent event) {
                if (event.getProperty() == property) {
                    Display.getDefault().asyncExec(op);
                }
            }
        };
        this.getPart().getParentPart().getModelElement().addListener(this.listPropertyListener);
        this.refreshEnabledState();
    }

    protected final ModelElementList<?> getList() {
        return (ModelElementList)this.getModelElement().parent();
    }

    private void refreshEnabledState() {
        this.setEnabled(this.computeEnabledState());
    }

    protected boolean computeEnabledState() {
        return this.contentTree != null && this.contentTree.getFilterText().length() == 0;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getPart().getParentPart().getModelElement().removeListener(this.listPropertyListener);
        if (this.contentTree != null) {
            this.contentTree.removeListener(this.contentTreeListener);
        }
    }
}

