/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sapphire.modeling.IExecutableModelElement;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphirePartEvent;
import org.eclipse.sapphire.ui.SapphirePartListener;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.SapphireWizardPart;
import org.eclipse.sapphire.ui.def.ISapphireWizardDef;
import org.eclipse.sapphire.ui.def.SapphireUiDefFactory;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.ProgressMonitorBridge;
import org.eclipse.sapphire.ui.swt.SapphireStatusDialog;
import org.eclipse.sapphire.ui.swt.SapphireWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireWizard<M extends IExecutableModelElement>
extends Wizard {
    private final M element;
    private final SapphireWizardPart part;
    private final SapphirePartListener listener;

    public SapphireWizard(M modelElement, String wizardDefPath) {
        this.element = modelElement;
        ISapphireWizardDef definition = SapphireUiDefFactory.getWizardDef(wizardDefPath);
        this.part = new SapphireWizardPart();
        this.part.init(null, (IModelElement)this.element, definition, Collections.<String, String>emptyMap());
        this.setWindowTitle(this.part.getLabel());
        this.listener = new SapphirePartListener(){

            public void handleEvent(SapphirePartEvent event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireWizard.this.refreshImage();
                }
            }
        };
        this.part.addListener(this.listener);
        this.refreshImage();
        this.setNeedsProgressMonitor(true);
    }

    public final M getModelElement() {
        return this.element;
    }

    public final void addPages() {
        for (SapphireWizardPagePart pagePart : this.part.getPages()) {
            this.addPage((IWizardPage)new SapphireWizardPage(pagePart));
        }
    }

    public final boolean performFinish() {
        final Status[] result = new Status[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                result[0] = SapphireWizard.this.element.execute((ProgressMonitor)new ProgressMonitorBridge(monitor));
            }
        };
        try {
            this.getContainer().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            SapphireUiFrameworkPlugin.log(e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        Status st = result[0];
        if (st.ok()) {
            this.performPostFinish();
            return true;
        }
        SapphireStatusDialog.open(this.getShell(), st);
        return false;
    }

    protected void performPostFinish() {
    }

    protected final void openFileEditors(IFile ... files) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file != null && file.isAccessible()) {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        SapphireUiFrameworkPlugin.log(e);
                    }
                }
                ++n2;
            }
        }
    }

    private final void refreshImage() {
        this.setDefaultPageImageDescriptor(SwtRendererUtil.toImageDescriptor(this.part.getImage()));
    }

    public void dispose() {
        super.dispose();
        this.part.removeListener(this.listener);
    }
}

