/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.renderer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.SapphireKeySequence;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireHotSpotsActionPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;

public final class SapphireKeyboardActionPresentation
extends SapphireHotSpotsActionPresentation {
    private final List<Control> attachedControls = new ArrayList<Control>();
    private KeyListener keyListener;

    public SapphireKeyboardActionPresentation(SapphireActionPresentationManager manager) {
        super(manager);
    }

    public void attach(final Control control) {
        this.attachedControls.add(control);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SapphireKeyboardActionPresentation.this.detach(control);
            }
        });
    }

    public void detach(Control control) {
        this.attachedControls.remove(control);
    }

    public void render() {
        this.keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                SapphireKeyboardActionPresentation.this.handleKeyEvent(event);
            }
        };
        for (Control control : this.attachedControls) {
            control.addKeyListener(this.keyListener);
        }
    }

    private void handleKeyEvent(KeyEvent event) {
        for (SapphireAction action : this.getManager().getActions()) {
            SapphireKeySequence keySequence;
            if (!action.hasActiveHandlers() || (keySequence = action.getKeyBinding()) == null) continue;
            int expectedStateMask = 0;
            for (SapphireKeySequence.Modifier modifier : keySequence.getModifiers()) {
                if (modifier == SapphireKeySequence.Modifier.SHIFT) {
                    expectedStateMask |= 0x20000;
                    continue;
                }
                if (modifier == SapphireKeySequence.Modifier.ALT) {
                    expectedStateMask |= 0x10000;
                    continue;
                }
                if (modifier != SapphireKeySequence.Modifier.CONTROL) continue;
                expectedStateMask |= 0x40000;
            }
            if (event.stateMask != expectedStateMask || event.keyCode != keySequence.getKeyCode()) continue;
            List<SapphireActionHandler> handlers = action.getActiveHandlers();
            if (handlers.size() == 1) {
                final SapphireActionHandler handler = handlers.get(0);
                Runnable runnable = new Runnable(){

                    public void run() {
                        handler.execute(SapphireKeyboardActionPresentation.this.getManager().getContext());
                    }
                };
                this.getManager().getContext().getDisplay().asyncExec(runnable);
            } else {
                for (SapphireActionPresentation presentation : this.getManager().getPresentations()) {
                    if (presentation.displayActionHandlerChoice(action)) break;
                }
            }
            return;
        }
    }

    public void dispose() {
        super.dispose();
        for (Control control : this.attachedControls) {
            if (control.isDisposed()) continue;
            control.removeKeyListener(this.keyListener);
        }
        this.attachedControls.clear();
    }
}

