/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramEmbeddedConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.geometry.IBendPoint;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramConnectionGeometry;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramGeometry;
import org.eclipse.sapphire.ui.diagram.geometry.IDiagramNodeGeometry;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.workspace.WorkspaceFileResourceStore;

public class DiagramGeometryWrapper {
    private IFile file;
    private IDiagramGeometry geometryModel;
    private SapphireDiagramEditorPagePart diagramPart;

    public DiagramGeometryWrapper(IFile file, SapphireDiagramEditorPagePart diagramPart) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.diagramPart = diagramPart;
        try {
            this.read();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log((Throwable)e);
        }
    }

    public boolean isGridPropertySet() {
        return this.geometryModel.getGridDefinition().isVisible().getContent(false) != null;
    }

    public boolean isGridVisible() {
        return (Boolean)this.geometryModel.getGridDefinition().isVisible().getContent();
    }

    public void setGridVisible(boolean visible) {
        this.geometryModel.getGridDefinition().setVisible(Boolean.valueOf(visible));
    }

    public void read() throws ResourceStoreException, CoreException {
        this.file.refreshLocal(0, null);
        XmlResourceStore resourceStore = new XmlResourceStore((ByteArrayResourceStore)new WorkspaceFileResourceStore(this.file));
        this.geometryModel = (IDiagramGeometry)IDiagramGeometry.TYPE.instantiate((Resource)new RootXmlResource(resourceStore));
        ModelElementList nodes = this.geometryModel.getDiagramNodeGeometries();
        for (IDiagramNodeGeometry node : nodes) {
            String id = (String)node.getNodeId().getContent();
            DiagramNodePart nodePart = IdUtil.getNodePart((SapphireDiagramEditorPagePart)this.diagramPart, (String)id);
            if (nodePart == null) continue;
            int x = node.getX().getContent() != null ? (Integer)node.getX().getContent() : -1;
            int y = node.getY().getContent() != null ? (Integer)node.getY().getContent() : -1;
            int width = node.getWidth().getContent() != null ? (Integer)node.getWidth().getContent() : -1;
            int height = node.getHeight().getContent() != null ? (Integer)node.getHeight().getContent() : -1;
            nodePart.setNodeBounds(x, y, width, height);
            ModelElementList connList = node.getEmbeddedConnectionGeometries();
            for (IDiagramConnectionGeometry connBend : connList) {
                String connId = (String)connBend.getConnectionId().getContent();
                DiagramConnectionPart connPart = IdUtil.getConnectionPart((DiagramNodePart)nodePart, (String)connId);
                if (connPart == null) continue;
                ModelElementList bps = connBend.getConnectionBendpoints();
                int index = 0;
                for (IBendPoint pt : bps) {
                    connPart.addBendpoint(index++, ((Integer)pt.getX().getContent()).intValue(), ((Integer)pt.getY().getContent()).intValue());
                }
            }
        }
        ModelElementList connList = this.geometryModel.getDiagramConnectionGeometries();
        for (IDiagramConnectionGeometry connBend : connList) {
            String connId = (String)connBend.getConnectionId().getContent();
            DiagramConnectionPart connPart = IdUtil.getConnectionPart((SapphireDiagramEditorPagePart)this.diagramPart, (String)connId);
            if (connPart == null) continue;
            ModelElementList bps = connBend.getConnectionBendpoints();
            int index = 0;
            for (IBendPoint pt : bps) {
                connPart.addBendpoint(index++, ((Integer)pt.getX().getContent()).intValue(), ((Integer)pt.getY().getContent()).intValue());
            }
        }
    }

    public void write() throws ResourceStoreException {
        this.geometryModel.getGridDefinition().setVisible(Boolean.valueOf(this.diagramPart.isGridVisible()));
        this.addNodeBoundsToModel();
        this.addConnectionBendpointsToModel();
        this.geometryModel.resource().save();
    }

    private void addNodeBoundsToModel() {
        this.geometryModel.getDiagramNodeGeometries().clear();
        for (DiagramNodeTemplate nodeTemplate : this.diagramPart.getNodeTemplates()) {
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                DiagramEmbeddedConnectionTemplate embeddedConnTemplate;
                String id = IdUtil.computeNodeId((DiagramNodePart)nodePart);
                IDiagramNodeGeometry diagramNode = (IDiagramNodeGeometry)this.geometryModel.getDiagramNodeGeometries().addNewElement();
                diagramNode.setNodeId(id);
                Bounds nodeBounds = nodePart.getNodeBounds();
                diagramNode.setX(Integer.valueOf(nodeBounds.getX()));
                diagramNode.setY(Integer.valueOf(nodeBounds.getY()));
                if (nodePart.canResizeShape()) {
                    diagramNode.setWidth(Integer.valueOf(nodeBounds.getWidth()));
                    diagramNode.setHeight(Integer.valueOf(nodeBounds.getHeight()));
                }
                if ((embeddedConnTemplate = nodePart.getDiagramNodeTemplate().getEmbeddedConnectionTemplate()) == null) continue;
                diagramNode.getEmbeddedConnectionGeometries().clear();
                List connParts = embeddedConnTemplate.getDiagramConnections(nodePart.getLocalModelElement());
                for (DiagramConnectionPart connPart : connParts) {
                    if (connPart.getConnectionBendpoints().size() <= 0) continue;
                    String connId = IdUtil.computeConnectionId((DiagramConnectionPart)connPart);
                    IDiagramConnectionGeometry conn = (IDiagramConnectionGeometry)diagramNode.getEmbeddedConnectionGeometries().addNewElement();
                    conn.setConnectionId(connId);
                    for (Point pt : connPart.getConnectionBendpoints()) {
                        IBendPoint pt2 = (IBendPoint)conn.getConnectionBendpoints().addNewElement();
                        pt2.setX(Integer.valueOf(pt.getX()));
                        pt2.setY(Integer.valueOf(pt.getY()));
                    }
                }
            }
        }
    }

    private void addConnectionBendpointsToModel() {
        this.geometryModel.getDiagramConnectionGeometries().clear();
        for (DiagramConnectionTemplate connTemplate : this.diagramPart.getConnectionTemplates()) {
            for (DiagramConnectionPart connPart : connTemplate.getDiagramConnections(null)) {
                if (connPart.getConnectionBendpoints().size() <= 0) continue;
                String id = IdUtil.computeConnectionId((DiagramConnectionPart)connPart);
                IDiagramConnectionGeometry conn = (IDiagramConnectionGeometry)this.geometryModel.getDiagramConnectionGeometries().addNewElement();
                conn.setConnectionId(id);
                for (Point pt : connPart.getConnectionBendpoints()) {
                    IBendPoint pt2 = (IBendPoint)conn.getConnectionBendpoints().addNewElement();
                    pt2.setX(Integer.valueOf(pt.getX()));
                    pt2.setY(Integer.valueOf(pt.getY()));
                }
            }
        }
    }
}

