/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.graphiti.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveBendpointFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IRemoveBendpointFeature;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDirectEditingContext;
import org.eclipse.graphiti.features.context.IMoveBendpointContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IRemoveBendpointContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.IIndependenceSolver;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.SapphireDiagramActionHandler;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.graphiti.DiagramRenderingContext;
import org.eclipse.sapphire.ui.swt.graphiti.editor.DiagramGeometryWrapper;
import org.eclipse.sapphire.ui.swt.graphiti.editor.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireAddBendpointFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireAddConnectionFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireAddNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateConnectionFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireCreateNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireDeleteFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireDirectEditConnectionFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireDirectEditNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireMoveBendpointFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireMoveNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireRemoveBendpointFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireRemoveFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireResizeShapeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireUpdateConnectionFeature;
import org.eclipse.sapphire.ui.swt.graphiti.features.SapphireUpdateNodeFeature;
import org.eclipse.sapphire.ui.swt.graphiti.providers.SapphireDiagramSolver;

public class SapphireDiagramFeatureProvider
extends DefaultFeatureProvider {
    public SapphireDiagramFeatureProvider(IDiagramTypeProvider dtp, IIndependenceSolver solver) {
        super(dtp);
        this.setIndependenceSolver(solver);
    }

    public DiagramGeometryWrapper getDiagramGeometry() {
        SapphireDiagramEditor diagramEditor = this.getDiagramEditor();
        return diagramEditor.getDiagramGeometry();
    }

    public IAddFeature getAddFeature(IAddContext context) {
        SapphireAction dropAction;
        SapphireDiagramActionHandler dropHandler;
        Object obj = context.getNewObject();
        if (obj instanceof DiagramNodePart) {
            return new SapphireAddNodeFeature((IFeatureProvider)this);
        }
        if (obj instanceof DiagramConnectionPart) {
            return new SapphireAddConnectionFeature((IFeatureProvider)this);
        }
        if (context.getTargetContainer() instanceof Diagram && (dropHandler = (SapphireDiagramActionHandler)(dropAction = this.getDiagramPart().getAction("Sapphire.Drop")).getFirstActiveHandler()) != null && dropHandler.canExecute(obj)) {
            return new SapphireAddNodeFeature((IFeatureProvider)this);
        }
        return super.getAddFeature(context);
    }

    public ICreateFeature[] getCreateFeatures() {
        List nodeTemplates = this.getDiagramPart().getNodeTemplates();
        ICreateFeature[] features = new ICreateFeature[nodeTemplates.size()];
        int i = 0;
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            SapphireCreateNodeFeature createNodeFeature = new SapphireCreateNodeFeature((IFeatureProvider)this, nodeTemplate);
            features[i++] = createNodeFeature;
        }
        return features;
    }

    public IDeleteFeature getDeleteFeature(IDeleteContext context) {
        return new SapphireDeleteFeature((IFeatureProvider)this);
    }

    public IRemoveFeature getRemoveFeature(IRemoveContext context) {
        return new SapphireRemoveFeature((IFeatureProvider)this);
    }

    public ICreateConnectionFeature[] getCreateConnectionFeatures() {
        SapphireDiagramEditorPagePart diagramPart = this.getDiagramPart();
        List connectionDefs = diagramPart.getDiagramConnectionDefs();
        ArrayList<SapphireCreateConnectionFeature> features = new ArrayList<SapphireCreateConnectionFeature>(connectionDefs.size());
        for (IDiagramConnectionDef connectionDef : connectionDefs) {
            String tpDesc;
            if (((Boolean)connectionDef.isImplicitConnection().getContent()).booleanValue()) break;
            String tpLabel = (String)connectionDef.getToolPaletteLabel().getContent();
            if (tpLabel != null) {
                tpLabel = IDiagramConnectionDef.PROP_TOOL_PALETTE_LABEL.getLocalizationService().text(tpLabel, CapitalizationType.TITLE_STYLE, false);
            }
            if ((tpDesc = (String)connectionDef.getToolPaletteDesc().getContent()) != null) {
                tpDesc = IDiagramConnectionDef.PROP_TOOL_PALETTE_DESC.getLocalizationService().text(tpDesc, CapitalizationType.TITLE_STYLE, false);
            }
            SapphireCreateConnectionFeature createConnectionFeature = new SapphireCreateConnectionFeature((IFeatureProvider)this, diagramPart, connectionDef, tpLabel, tpDesc);
            features.add(createConnectionFeature);
        }
        return features.toArray(new ICreateConnectionFeature[0]);
    }

    public IDirectEditingFeature getDirectEditingFeature(IDirectEditingContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)pe.eContainer());
        if (bo instanceof DiagramNodePart) {
            return new SapphireDirectEditNodeFeature((IFeatureProvider)this);
        }
        if (bo instanceof DiagramConnectionPart) {
            return new SapphireDirectEditConnectionFeature((IFeatureProvider)this);
        }
        return super.getDirectEditingFeature(context);
    }

    public IUpdateFeature getUpdateFeature(IUpdateContext context) {
        Object bo;
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            Object bo2 = this.getBusinessObjectForPictogramElement(pe);
            if (bo2 instanceof DiagramNodePart) {
                return new SapphireUpdateNodeFeature((IFeatureProvider)this);
            }
        } else if (pe instanceof Connection && (bo = this.getBusinessObjectForPictogramElement(pe)) instanceof DiagramConnectionPart) {
            return new SapphireUpdateConnectionFeature((IFeatureProvider)this);
        }
        return super.getUpdateFeature(context);
    }

    public IAddBendpointFeature getAddBendpointFeature(IAddBendpointContext context) {
        SapphireAddBendpointFeature ret = new SapphireAddBendpointFeature((IFeatureProvider)this);
        return ret;
    }

    public IRemoveBendpointFeature getRemoveBendpointFeature(IRemoveBendpointContext context) {
        SapphireRemoveBendpointFeature ret = new SapphireRemoveBendpointFeature((IFeatureProvider)this);
        return ret;
    }

    public IMoveBendpointFeature getMoveBendpointFeature(IMoveBendpointContext context) {
        SapphireMoveBendpointFeature ret = new SapphireMoveBendpointFeature((IFeatureProvider)this);
        return ret;
    }

    public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
        return new SapphireMoveNodeFeature((IFeatureProvider)this);
    }

    public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
        SapphireResizeShapeFeature ret = new SapphireResizeShapeFeature((IFeatureProvider)this);
        return ret;
    }

    public void remove(Object bo) {
        ((SapphireDiagramSolver)this.getIndependenceSolver()).removeBO(bo);
    }

    public void addRenderingContext(SapphirePart part, DiagramRenderingContext ctx) {
        ((SapphireDiagramSolver)this.getIndependenceSolver()).addRendingContext((ISapphirePart)part, ctx);
    }

    public DiagramRenderingContext getRenderingContext(ISapphirePart part) {
        return ((SapphireDiagramSolver)this.getIndependenceSolver()).getRenderingContext(part);
    }

    private SapphireDiagramEditor getDiagramEditor() {
        SapphireDiagramEditor diagramEditor = (SapphireDiagramEditor)this.getDiagramTypeProvider().getDiagramEditor();
        return diagramEditor;
    }

    private SapphireDiagramEditorPagePart getDiagramPart() {
        SapphireDiagramEditor diagramEditor = this.getDiagramEditor();
        return diagramEditor.getPart();
    }
}

