/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.calendar.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.samples.calendar.ICalendar;
import org.eclipse.sapphire.samples.calendar.integrated.internal.CalendarResource;
import org.eclipse.sapphire.samples.contacts.IContactsDatabase;
import org.eclipse.sapphire.ui.CorruptedResourceExceptionInterceptorImpl;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public final class CalendarEditor
extends SapphireEditor {
    private StructuredTextEditor calendarSourceEditor;
    private StructuredTextEditor contactsSourceEditor;
    private ICalendar modelCalendar;
    private org.eclipse.sapphire.samples.calendar.integrated.ICalendar modelCalendarIntegrated;
    private IContactsDatabase modelContacts;
    private MasterDetailsEditorPage calendarDesignPage;
    private MasterDetailsEditorPage contactsDesignPage;

    public CalendarEditor() {
        super("org.eclipse.sapphire.samples");
    }

    protected void createSourcePages() throws PartInitException {
        this.calendarSourceEditor = new StructuredTextEditor();
        this.calendarSourceEditor.setEditorPart((IEditorPart)this);
        FileEditorInput rootEditorInput = (FileEditorInput)this.getEditorInput();
        int index = this.addPage((IEditorPart)this.calendarSourceEditor, (IEditorInput)rootEditorInput);
        this.setPageText(index, "calendar.xml");
        this.contactsSourceEditor = new StructuredTextEditor();
        this.contactsSourceEditor.setEditorPart((IEditorPart)this);
        IFile contactsFile = rootEditorInput.getFile().getParent().getFile((IPath)new Path("contacts.xml"));
        index = this.addPage((IEditorPart)this.contactsSourceEditor, (IEditorInput)new FileEditorInput(contactsFile));
        this.setPageText(index, "contacts.xml");
    }

    protected IModelElement createModel() {
        this.modelCalendar = (ICalendar)ICalendar.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.calendarSourceEditor)));
        this.modelContacts = (IContactsDatabase)IContactsDatabase.TYPE.instantiate((Resource)new RootXmlResource((XmlResourceStore)new XmlEditorResourceStore((SapphireEditor)this, this.contactsSourceEditor)));
        this.modelCalendarIntegrated = (org.eclipse.sapphire.samples.calendar.integrated.ICalendar)org.eclipse.sapphire.samples.calendar.integrated.ICalendar.TYPE.instantiate((Resource)new CalendarResource(this.modelCalendar, this.modelContacts));
        return this.modelCalendarIntegrated;
    }

    protected void adaptModel(IModelElement model) {
        CorruptedResourceExceptionInterceptorImpl interceptor = new CorruptedResourceExceptionInterceptorImpl(this.getEditorSite().getShell());
        this.modelCalendar.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
        this.modelContacts.resource().setCorruptedResourceExceptionInterceptor((CorruptedResourceExceptionInterceptor)interceptor);
    }

    protected final void createFormPages() throws PartInitException {
        Path path = new Path("org.eclipse.sapphire.samples/org/eclipse/sapphire/samples/calendar/integrated/CalendarEditor.sdef/main");
        this.calendarDesignPage = new MasterDetailsEditorPage((SapphireEditor)this, (IModelElement)this.modelCalendarIntegrated, (IPath)path);
        this.addPage(0, (IFormPage)this.calendarDesignPage);
        path = new Path("org.eclipse.sapphire.samples/org/eclipse/sapphire/samples/contacts/ContactsDatabaseEditor.sdef/main");
        this.contactsDesignPage = new MasterDetailsEditorPage((SapphireEditor)this, (IModelElement)this.modelContacts, (IPath)path, Resources.contactsPageName);
        this.addPage(1, (IFormPage)this.contactsDesignPage);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page == this.calendarSourceEditor) {
            return (IContentOutlinePage)this.calendarSourceEditor.getAdapter(IContentOutlinePage.class);
        }
        if (page == this.contactsSourceEditor) {
            return (IContentOutlinePage)this.contactsSourceEditor.getAdapter(IContentOutlinePage.class);
        }
        return super.getContentOutline(page);
    }

    public ICalendar getCalendar() {
        return this.modelCalendar;
    }

    public org.eclipse.sapphire.samples.calendar.integrated.ICalendar getCalendarIntegrated() {
        return this.modelCalendarIntegrated;
    }

    public IContactsDatabase getContactsDatabase() {
        return this.modelContacts;
    }

    private static final class Resources
    extends NLS {
        public static String contactsPageName;

        static {
            Resources.initializeMessages((String)CalendarEditor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

